/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.util.OverthereFileCopier;

public abstract class BaseOverthereFile<C extends BaseOverthereConnection>
implements OverthereFile {
    protected C connection;

    protected BaseOverthereFile() {
        this.connection = null;
    }

    protected BaseOverthereFile(C c) {
        this.connection = c;
    }

    public C getConnection() {
        return this.connection;
    }

    @Override
    public OverthereFile getFile(String string) {
        return this.getConnection().getFile(this, string);
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        if (this.isDirectory()) {
            for (OverthereFile overthereFile : this.listFiles()) {
                overthereFile.deleteRecursively();
            }
        }
        this.delete();
    }

    @Override
    public final void copyTo(OverthereFile overthereFile) {
        Preconditions.checkArgument((boolean)(overthereFile instanceof BaseOverthereFile), (Object)"dest is not a subclass of BaseOverthereFile");
        ((BaseOverthereFile)overthereFile).copyFrom(this);
    }

    protected void copyFrom(OverthereFile overthereFile) {
        OverthereFileCopier.copy(overthereFile, this);
    }

    public abstract String toString();
}

