/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.ssh.RegularExpressionPasswordResponseProvider;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshProcess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshConnection
extends BaseOverthereConnection {
    public static final String PTY_PATTERN = "(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)";
    public static final String NOCD_PSEUDO_COMMAND = "nocd";
    protected final SshConnectionType sshConnectionType;
    protected final String host;
    protected final int port;
    protected final String username;
    protected final String password;
    protected String interactiveKeyboardAuthPromptRegex;
    protected final String privateKeyFile;
    protected final String passphrase;
    protected boolean allocateDefaultPty;
    protected final String allocatePty;
    protected SSHClient sshClient;
    private static final Pattern ptyPattern = Pattern.compile("(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)");
    @VisibleForTesting
    protected Factory<SSHClient> sshClientFactory = new Factory<SSHClient>(){

        public SSHClient create() {
            return new SSHClient();
        }
    };
    private static Logger logger = LoggerFactory.getLogger(SshConnection.class);

    public SshConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper, true);
        this.sshConnectionType = (SshConnectionType)((Object)connectionOptions.get("connectionType"));
        InetSocketAddress inetSocketAddress = addressPortMapper.map(InetSocketAddress.createUnresolved((String)connectionOptions.get("address"), connectionOptions.get("port", 22)));
        this.host = inetSocketAddress.getHostName();
        this.port = inetSocketAddress.getPort();
        this.username = (String)connectionOptions.get("username");
        this.password = (String)connectionOptions.getOptional("password");
        this.interactiveKeyboardAuthPromptRegex = connectionOptions.get("interactiveKeyboardAuthRegex", ".*Password:[ ]?");
        this.privateKeyFile = (String)connectionOptions.getOptional("privateKeyFile");
        this.passphrase = (String)connectionOptions.getOptional("passphrase");
        this.allocateDefaultPty = connectionOptions.get("allocateDefaultPty", false);
        this.allocatePty = connectionOptions.get("allocatePty", SshConnectionBuilder.ALLOCATE_PTY_DEFAULT);
    }

    protected void connect() {
        try {
            SSHClient sSHClient = (SSHClient)this.sshClientFactory.create();
            sSHClient.setConnectTimeout(this.connectionTimeoutMillis);
            sSHClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            try {
                sSHClient.connect(this.host, this.port);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot connect to " + this.host + ":" + this.port, iOException);
            }
            if (this.privateKeyFile != null) {
                KeyProvider keyProvider;
                if (this.password != null) {
                    logger.warn("The privateKeyFile and password connection options have both been set for the connection {}. Ignoring password and using privateKeyFile.", (Object)this);
                }
                try {
                    keyProvider = this.passphrase == null ? sSHClient.loadKeys(this.privateKeyFile) : sSHClient.loadKeys(this.privateKeyFile, this.passphrase);
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException("Cannot read key from private key file " + this.privateKeyFile, iOException);
                }
                sSHClient.authPublickey(this.username, new KeyProvider[]{keyProvider});
            } else if (this.password != null) {
                PasswordFinder passwordFinder = this.getPasswordFinder();
                sSHClient.auth(this.username, new AuthMethod[]{new AuthPassword(passwordFinder), new AuthKeyboardInteractive((ChallengeResponseProvider)new RegularExpressionPasswordResponseProvider(passwordFinder, this.interactiveKeyboardAuthPromptRegex))});
            }
            this.sshClient = sSHClient;
        }
        catch (SSHException sSHException) {
            throw new RuntimeIOException("Cannot connect to " + this, sSHException);
        }
    }

    private PasswordFinder getPasswordFinder() {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return SshConnection.this.password.toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Already disconnected");
        try {
            this.sshClient.disconnect();
        }
        catch (Exception exception) {
            logger.error("Unexpected exception received while disconnecting from " + this, (Throwable)exception);
        }
        finally {
            this.sshClient = null;
        }
    }

    protected SSHClient getSshClient() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Not (yet) connected");
        return this.sshClient;
    }

    @Override
    public final OverthereFile getFile(String string) throws RuntimeIOException {
        return this.getFile(string, false);
    }

    @Override
    public final OverthereFile getFile(OverthereFile overthereFile, String string) throws RuntimeIOException {
        return this.getFile(overthereFile, string, false);
    }

    @Override
    protected final OverthereFile getFileForTempFile(OverthereFile overthereFile, String string) {
        return this.getFile(overthereFile, string, true);
    }

    protected abstract OverthereFile getFile(String var1, boolean var2) throws RuntimeIOException;

    protected OverthereFile getFile(OverthereFile overthereFile, String string, boolean bl) throws RuntimeIOException {
        if (!(overthereFile instanceof SshFile)) {
            throw new IllegalStateException("parent is not a file on an SSH host");
        }
        if (overthereFile.getConnection() != this) {
            throw new IllegalStateException("parent is not a file in this connection");
        }
        return this.getFile(overthereFile.getPath() + this.getHostOperatingSystem().getFileSeparator() + string, bl);
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmdLine) {
        Preconditions.checkNotNull((Object)cmdLine, (Object)"Cannot execute null command line");
        Preconditions.checkArgument((cmdLine.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot execute empty command line");
        CmdLine cmdLine2 = this.processCommandLine(cmdLine);
        try {
            Session session = this.getSshClient().startSession();
            if (this.allocatePty != null && !this.allocatePty.isEmpty()) {
                if (this.allocateDefaultPty) {
                    logger.warn("The allocatePty and allocateDefaultPty connection options have both been set for the connection {}. Ignoring allocateDefaultPty and using allocatePty.", (Object)this);
                }
                Matcher matcher = ptyPattern.matcher(this.allocatePty);
                Preconditions.checkArgument((boolean)matcher.matches(), (String)"Value for allocatePty [%s] does not match pattern \"(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)\"", (Object[])new Object[]{this.allocateDefaultPty});
                String string = matcher.group(1);
                int n = Integer.valueOf(matcher.group(2));
                int n2 = Integer.valueOf(matcher.group(3));
                int n3 = Integer.valueOf(matcher.group(4));
                int n4 = Integer.valueOf(matcher.group(5));
                logger.debug("Allocating PTY {}:{}:{}:{}:{}", new Object[]{string, n, n2, n3, n4});
                session.allocatePTY(string, n, n2, n3, n4, Collections.emptyMap());
            } else if (this.allocateDefaultPty) {
                logger.debug("Allocating default PTY");
                session.allocateDefaultPTY();
            }
            return this.createProcess(session, cmdLine2);
        }
        catch (SSHException sSHException) {
            throw new RuntimeIOException("Cannot execute remote command \"" + cmdLine2.toCommandLine(this.getHostOperatingSystem(), true) + "\" on " + this, sSHException);
        }
    }

    protected CmdLine processCommandLine(CmdLine cmdLine) {
        if (this.startsWithPseudoCommand(cmdLine, NOCD_PSEUDO_COMMAND)) {
            logger.trace("Not prefixing command line with cd statement because the nocd pseudo command was present, but the pseudo command will be stripped");
            logger.trace("Replacing: {}", (Object)cmdLine);
            CmdLine cmdLine2 = SshConnection.stripPrefixedPseudoCommand(cmdLine);
            logger.trace("With     : {}", (Object)cmdLine2);
            return cmdLine2;
        }
        if (this.getWorkingDirectory() != null) {
            logger.trace("Prefixing command line with cd statement because the current working directory was set");
            logger.trace("Replacing: {}", (Object)cmdLine);
            CmdLine cmdLine3 = new CmdLine();
            cmdLine3.addArgument("cd");
            cmdLine3.addArgument(this.workingDirectory.getPath());
            cmdLine3.addRaw(this.os.getCommandSeparator());
            for (CmdLineArgument cmdLineArgument : cmdLine.getArguments()) {
                cmdLine3.add(cmdLineArgument);
            }
            logger.trace("With     : {}", (Object)cmdLine3);
            return cmdLine3;
        }
        logger.trace("Not prefixing command line with cd statement because the current working directory was not set");
        logger.trace("Keeping  : {}", (Object)cmdLine);
        return cmdLine;
    }

    protected boolean startsWithPseudoCommand(CmdLine cmdLine, String string) {
        return cmdLine.getArguments().size() >= 2 && cmdLine.getArguments().get(0).toString(this.os, false).equals(string);
    }

    protected SshProcess createProcess(Session session, CmdLine cmdLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, cmdLine);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.host + ":" + this.port;
    }

    protected static CmdLine stripPrefixedPseudoCommand(CmdLine cmdLine) {
        return new CmdLine().add(cmdLine.getArguments().subList(1, cmdLine.getArguments().size()));
    }

    protected static CmdLine prefixWithPseudoCommand(CmdLine cmdLine, String string) {
        CmdLine cmdLine2 = new CmdLine();
        cmdLine2.addArgument(string);
        cmdLine2.add(cmdLine.getArguments());
        return cmdLine2;
    }
}

