/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshProcess
implements OverthereProcess {
    private SshConnection connection;
    private final Session session;
    private final String encodedCommandLine;
    private final Session.Command command;
    private static Logger logger = LoggerFactory.getLogger(SshProcess.class);

    SshProcess(SshConnection sshConnection, OperatingSystemFamily operatingSystemFamily, Session session, CmdLine cmdLine) throws TransportException, ConnectionException {
        this.connection = sshConnection;
        this.session = session;
        this.encodedCommandLine = cmdLine.toCommandLine(operatingSystemFamily, true);
        logger.debug("Executing command {} on {}", (Object)this.encodedCommandLine, (Object)sshConnection);
        this.command = session.exec(cmdLine.toCommandLine(operatingSystemFamily, false));
    }

    @Override
    public OutputStream getStdin() {
        return this.command.getOutputStream();
    }

    @Override
    public InputStream getStdout() {
        return this.command.getInputStream();
    }

    @Override
    public InputStream getStderr() {
        return this.command.getErrorStream();
    }

    @Override
    public int waitFor() {
        try {
            this.command.join();
            Integer n = this.command.getExitStatus();
            logger.info("Command {} on {} returned {}", new Object[]{this.encodedCommandLine, this.connection, n});
            this.closeSession();
            if (n == null) {
                logger.warn("Command {} on {} could not be started. This may be caused by the connection option allocateDefaultPty being set to true.", new Object[]{this.encodedCommandLine, this.connection});
                return -1;
            }
            return n;
        }
        catch (ConnectionException connectionException) {
            throw new RuntimeIOException("Caught exception while awaiting end of process", connectionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this.command.signal(Signal.KILL);
        }
        catch (TransportException transportException) {
            logger.warn("Could not send the KILL signal to the command, closing the session.", (Throwable)transportException);
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        if (this.session.isOpen()) {
            try {
                this.session.close();
            }
            catch (SSHException sSHException) {
                throw new RuntimeIOException("Could not close the SSH session", sSHException);
            }
        }
    }
}

