/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSudoFile;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoConnection
extends SshScpConnection {
    public static final String NOSUDO_PSEUDO_COMMAND = "nosudo";
    protected String sudoUsername;
    protected String sudoCommandPrefix;
    protected boolean sudoQuoteCommand;
    protected boolean sudoOverrideUmask;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper);
        this.sudoUsername = (String)connectionOptions.get("sudoUsername");
        this.sudoCommandPrefix = connectionOptions.get("sudoCommandPrefix", "sudo -u {0}");
        this.sudoQuoteCommand = connectionOptions.get("sudoQuoteCommand", false);
        this.sudoOverrideUmask = connectionOptions.get("sudoOverrideUmask", false);
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmdLine) {
        CmdLine cmdLine2;
        if (this.startsWithPseudoCommand(cmdLine, NOSUDO_PSEUDO_COMMAND)) {
            this.logger.trace("Not prefixing command line with sudo statement because the nosudo pseudo command was present, but the pseudo command will be stripped");
            this.logger.trace("Replacing: {}", (Object)cmdLine);
            cmdLine2 = SshSudoConnection.stripPrefixedPseudoCommand(cmdLine);
            this.logger.trace("With     : {}", (Object)cmdLine2);
        } else {
            this.logger.trace("Prefixing command line with sudo statement");
            this.logger.trace("Replacing: {}", (Object)cmdLine);
            boolean bl = this.startsWithPseudoCommand(cmdLine, "nocd");
            cmdLine2 = bl ? SshSudoConnection.stripPrefixedPseudoCommand(cmdLine) : cmdLine;
            cmdLine2 = this.prefixWithSudoCommand(cmdLine2);
            if (bl) {
                cmdLine2 = SshSudoConnection.prefixWithPseudoCommand(cmdLine2, "nocd");
            }
            this.logger.trace("With     : {}", (Object)cmdLine2);
        }
        return super.processCommandLine(cmdLine2);
    }

    protected CmdLine prefixWithSudoCommand(CmdLine cmdLine) {
        CmdLine cmdLine2 = new CmdLine();
        this.addSudoStatement(cmdLine2);
        if (this.sudoQuoteCommand) {
            cmdLine2.addNested(cmdLine);
        } else {
            for (CmdLineArgument cmdLineArgument : cmdLine.getArguments()) {
                cmdLine2.add(cmdLineArgument);
                if (!cmdLineArgument.toString(this.os, false).equals("|") && !cmdLineArgument.toString(this.os, false).equals(";")) continue;
                this.addSudoStatement(cmdLine2);
            }
        }
        return cmdLine2;
    }

    protected void addSudoStatement(CmdLine cmdLine) {
        String string = MessageFormat.format(this.sudoCommandPrefix, this.sudoUsername);
        for (String string2 : string.split("\\s+")) {
            cmdLine.addArgument(string2);
        }
    }

    @Override
    protected OverthereFile getFile(String string, boolean bl) throws RuntimeIOException {
        return new SshSudoFile(this, string, bl);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + ":" + this.sudoUsername + "@" + this.host + ":" + this.port;
    }
}

