/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class Permissions {
    static final Splitter PERMISSION_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    static final Joiner PERMISSION_JOINER = Joiner.on((String)",").skipNulls();
    private static final Logger logger = LoggerFactory.getLogger(Permissions.class);

    static Iterable<String> splitPrincipals(String string) {
        if (string == null) {
            return Lists.newArrayList();
        }
        return PERMISSION_SPLITTER.split((CharSequence)string);
    }

    static Iterable<Integer> splitRoles(String string) {
        return Iterables.transform(Permissions.splitPrincipals(string), (Function)new Function<String, Integer>(){

            public Integer apply(String string) {
                return Integer.valueOf(string);
            }
        });
    }

    static String joinRoles(Iterable<Integer> iterable) {
        return PERMISSION_JOINER.join(iterable);
    }

    static String joinRoles(Integer ... integerArray) {
        return PERMISSION_JOINER.join((Object[])integerArray);
    }

    static Iterable<Integer> rolesToIds(Iterable<Role> iterable) {
        return Iterables.transform(iterable, (Function)new Function<Role, Integer>(){

            public Integer apply(Role role) {
                return role.getId();
            }
        });
    }

    public static ImmutableMap<Integer, Role> buildLookup(List<Role> list) {
        return Maps.uniqueIndex(list, (Function)new Function<Role, Integer>(){

            public Integer apply(Role role) {
                return role.getId();
            }
        });
    }

    static List<String> getFullTreeAsSeparateNodesInChildToRootOrder(String string) {
        ArrayList arrayList = Lists.newArrayList();
        int n = string.indexOf(47);
        while (n > -1) {
            arrayList.add(string.substring(0, n));
            n = string.indexOf(47, n + 1);
        }
        arrayList.add(string);
        Collections.reverse(arrayList);
        logger.debug("Split off tree: {} to {}", (Object)string, (Object)arrayList);
        return arrayList;
    }

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static Collection<String> authenticationToPrincipals(Authentication authentication) {
        String string = authentication.getName();
        Iterable<String> iterable = Permissions.getAuthorities(authentication);
        HashSet hashSet = Sets.newHashSet(iterable);
        hashSet.add(string);
        logger.debug("All principals for user [{}] are: {}", (Object)authentication.getName(), (Object)hashSet);
        return hashSet;
    }

    private static Iterable<String> getAuthorities(Authentication authentication) {
        return Iterables.transform((Iterable)authentication.getAuthorities(), (Function)new Function<GrantedAuthority, String>(){

            public String apply(GrantedAuthority grantedAuthority) {
                return grantedAuthority.getAuthority();
            }
        });
    }

    static Node readSecurable(String string, Session session) throws RepositoryException {
        Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
        Permissions.checkSecurable(node);
        return node;
    }

    static void checkSecurable(Node node) throws RepositoryException {
        String string = node.getProperty("$configuration.item.type").getString();
        Checks.checkArgument(Permissions.isSecurable(node), "Cannot set permission on [%s] because it is not a Directory or Root [%s]", JcrPathHelper.getIdFromAbsolutePath(node.getPath()), string);
    }

    static boolean isSecurable(Node node) throws RepositoryException {
        String string = node.getProperty("$configuration.item.type").getString();
        return Type.valueOf((String)string).isSubTypeOf(Type.valueOf(Securable.class));
    }

    static Map<String, String> readPermissionMap(Node node) throws RepositoryException {
        Map<Object, Object> map = Maps.newHashMap();
        if (node.hasProperty("securityPermissions")) {
            Property property = node.getProperty("securityPermissions");
            map = JcrUtils.readMap(property);
        }
        return map;
    }

    static void writePermissionMap(Node node, Map<String, String> map) throws RepositoryException {
        JcrUtils.writeMap(node, "securityPermissions", map);
    }

    public static Collection<Permission> isApplicableTo(Collection<Permission> collection, final String string) {
        return Collections2.filter(collection, (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return !permission.isApplicableTo(string);
            }
        });
    }
}

