/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.ReadPermissionHandler;

public enum Permission {
    LOGIN("login", PermissionHandler.Level.GLOBAL),
    READ("read", PermissionHandler.Level.CI, new ReadPermissionHandler()),
    IMPORT_INITIAL("import#initial", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    IMPORT_UPGRADE("import#upgrade", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    IMPORT_REMOVE("import#remove", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.APPLICATIONS),
    DEPLOY_INITIAL("deploy#initial", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    DEPLOY_UPGRADE("deploy#upgrade", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    DISCOVERY("discovery", PermissionHandler.Level.GLOBAL),
    UNDEPLOY("deploy#undeploy", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    EDIT_REPO("repo#edit", PermissionHandler.Level.CI),
    EDIT_SECURITY("security#edit", PermissionHandler.Level.GLOBAL),
    TASK_MOVESTEP("task#move_step", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    TASK_SKIPSTEP("task#skip_step", PermissionHandler.Level.CI, Metadata.ConfigurationItemRoot.ENVIRONMENTS),
    TASK_ASSIGN("task#assign", PermissionHandler.Level.GLOBAL),
    CONTROLTASK_EXECUTE("controltask#execute", PermissionHandler.Level.GLOBAL),
    ADMIN("admin", PermissionHandler.Level.GLOBAL);

    private PermissionHandler permissionHandler;
    private String permissionName;
    private PermissionHandler.Level level;
    private Metadata.ConfigurationItemRoot root;

    private Permission(String string2, PermissionHandler.Level level) {
        this.permissionName = string2;
        this.level = level;
        this.permissionHandler = new PermissionHandler(this);
    }

    private Permission(String string2, PermissionHandler.Level level, PermissionHandler permissionHandler) {
        this.permissionName = string2;
        this.level = level;
        this.permissionHandler = permissionHandler;
    }

    private Permission(String string2, PermissionHandler.Level level, Metadata.ConfigurationItemRoot configurationItemRoot) {
        this(string2, level);
        this.root = configurationItemRoot;
    }

    public static Permission find(String string) {
        for (Permission permission : Permission.values()) {
            if (!permission.permissionName.equals(string)) continue;
            return permission;
        }
        return null;
    }

    public PermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public PermissionHandler.Level getLevel() {
        return this.level;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public boolean isApplicableTo(String string) {
        string = Strings.nullToEmpty((String)string);
        if (this.level == PermissionHandler.Level.GLOBAL && string.isEmpty()) {
            return true;
        }
        if (this.level == PermissionHandler.Level.BOTH && string.isEmpty()) {
            return true;
        }
        if (this.level == PermissionHandler.Level.CI && string.isEmpty()) {
            return false;
        }
        if (this.level != PermissionHandler.Level.BOTH && this.level != PermissionHandler.Level.CI) {
            return false;
        }
        if (this.root == null) {
            return true;
        }
        return string.startsWith(this.root.getRootNodeName());
    }
}

