/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private RepositoryService repository;
    private TypeCalculator calculator;
    private static final Logger logger = LoggerFactory.getLogger(DeployedGenerator.class);

    @Autowired
    public DeployedGenerator(RepositoryService repositoryService, TypeCalculator typeCalculator) {
        this.calculator = typeCalculator;
        this.repository = repositoryService;
    }

    public Deployed<?, ?> createMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary consolidatedDictionary) {
        return this.generateMostSpecificDeployed(deployable, container, consolidatedDictionary, true);
    }

    public Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary consolidatedDictionary) {
        return this.generateMostSpecificDeployed(deployable, container, consolidatedDictionary, false);
    }

    private Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary consolidatedDictionary, boolean bl) {
        Type type = this.calculator.findMostSpecificDeployedTypeForDeployableAndContainerTypes(deployable.getType(), container.getType());
        if (type != null && (bl || this.dontUseTagsOrTagsMatch(deployable, container))) {
            return this.generateDeployed(deployable, container, type, consolidatedDictionary);
        }
        return null;
    }

    private boolean dontUseTagsOrTagsMatch(Deployable deployable, Container container) {
        Set<String> set = this.emptySetIfNull(deployable.getTags());
        Set<String> set2 = this.emptySetIfNull(container.getTags());
        logger.debug("Using tags: deployable [{}] and container [{}]", set, set2);
        return set.isEmpty() && set2.isEmpty() || !Sets.intersection(set, set2).isEmpty();
    }

    private Set<String> emptySetIfNull(Set<String> set) {
        if (set == null) {
            return Sets.newHashSet();
        }
        return set;
    }

    public Deployed<?, ?> generateDeployed(Deployable deployable, Container container, Type type, ConsolidatedDictionary consolidatedDictionary) {
        Deployed<Deployable, Container> deployed = this.basicDeployed(deployable, container, type);
        this.setPropertyPlaceholders(deployed, deployable, consolidatedDictionary);
        this.setFilePlaceholders(deployed, deployable, consolidatedDictionary);
        return deployed;
    }

    private Deployed<Deployable, Container> basicDeployed(Deployable deployable, Container container, Type type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        Deployed deployed = (Deployed)descriptor.newInstance();
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        IdGenerator.generateId((Deployed)deployed);
        return deployed;
    }

    private void setPropertyPlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary consolidatedDictionary) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            String string = propertyDescriptor.getName();
            if (string.equals("placeholders")) continue;
            PropertyDescriptor propertyDescriptor2 = descriptor2.getPropertyDescriptor(string);
            if (propertyDescriptor2 != null) {
                String string2;
                Object object = propertyDescriptor2.get((ConfigurationItem)deployable);
                String string3 = string2 = object == null ? null : object.toString();
                if (Strings.isNullOrEmpty((String)string2)) {
                    this.setDeployedFromDictionary(deployed, consolidatedDictionary, propertyDescriptor, propertyDescriptor2);
                    continue;
                }
                try {
                    object = consolidatedDictionary.resolve(object, propertyDescriptor2);
                    object = this.convertToReferenceIfNeeded(object, propertyDescriptor2, propertyDescriptor);
                    propertyDescriptor.set(deployed, object);
                }
                catch (DictionaryValueException dictionaryValueException) {
                    logger.warn("Could not resolve dictionary keys for property " + propertyDescriptor2 + " on " + deployed + ". Property will be left empty.");
                    logger.trace("Exception was", (Throwable)dictionaryValueException);
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Could not convert (resolved) value to correct type for property " + propertyDescriptor2 + " on " + deployed + ". Property will be left empty.");
                    logger.trace("Exception was", (Throwable)runtimeException);
                }
                continue;
            }
            this.setDeployedFromDictionary(deployed, consolidatedDictionary, propertyDescriptor, null);
        }
    }

    private void setDeployedFromDictionary(Deployed<Deployable, Container> deployed, ConsolidatedDictionary consolidatedDictionary, PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        if (consolidatedDictionary.containsKey(propertyDescriptor.getFqn())) {
            Object object = consolidatedDictionary.get(propertyDescriptor.getFqn());
            object = this.convertToReferenceIfNeeded(object, propertyDescriptor2, propertyDescriptor);
            propertyDescriptor.set(deployed, object);
        }
    }

    private void setFilePlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary consolidatedDictionary) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("placeholders");
        if (propertyDescriptor != null) {
            PropertyDescriptor propertyDescriptor2 = descriptor2.getPropertyDescriptor("placeholders");
            Set set = (Set)propertyDescriptor2.get((ConfigurationItem)deployable);
            propertyDescriptor.set(deployed, this.resolveFilePlaceholders(Maps.newHashMap(), set, consolidatedDictionary));
        }
    }

    public Deployed<?, ?> generateUpgradedDeployed(Deployable deployable, Deployed<?, ?> deployed, ConsolidatedDictionary consolidatedDictionary) {
        Deployed<?, ?> deployed2 = this.createUpgradedDeployed(deployable, deployed);
        this.setUpgradedPropertyPlaceholders(deployed2, deployable, deployed, consolidatedDictionary);
        this.setUpgradedFilePlaceholders(deployed2, deployable, deployed, consolidatedDictionary);
        return deployed2;
    }

    private Deployed<?, ?> createUpgradedDeployed(Deployable deployable, Deployed<?, ?> deployed) {
        Type type;
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Type type2 = descriptor.getDeployableType();
        Checks.checkArgument(type2.equals((Object)(type = deployable.getType())) || DescriptorRegistry.getSubtypes((Type)type2).contains(type), "The new Deployable type %s should be assignable to %s", type, type2);
        Deployed deployed2 = (Deployed)descriptor.newInstance();
        deployed2.setDeployable(deployable);
        deployed2.setId(deployed.getId());
        return deployed2;
    }

    private void setUpgradedPropertyPlaceholders(Deployed<?, ?> deployed, Deployable deployable, Deployed<?, ?> deployed2, ConsolidatedDictionary consolidatedDictionary) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed2.getType());
        Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)descriptor.getDeployableType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object object;
            String string = propertyDescriptor.getName();
            if (string.equals("placeholders") || string.equals("deployable")) continue;
            Object object2 = object = propertyDescriptor.get(deployed2);
            PropertyDescriptor propertyDescriptor2 = descriptor2.getPropertyDescriptor(string);
            if (propertyDescriptor2 != null) {
                String string2;
                Object object3 = propertyDescriptor2.get((ConfigurationItem)deployed2.getDeployable());
                String string3 = string2 = object != null ? object.toString() : null;
                if (object3 != null && (object3.equals(string2) || MustachePlaceholderScanner.hasPlaceholders(object3.toString()))) {
                    object2 = propertyDescriptor2.get((ConfigurationItem)deployable);
                    try {
                        object2 = consolidatedDictionary.resolve(object2, propertyDescriptor2);
                        object2 = this.convertToReferenceIfNeeded(object2, propertyDescriptor2, propertyDescriptor);
                    }
                    catch (DictionaryValueException dictionaryValueException) {
                        object2 = object;
                        logger.warn("Could not resolve dictionary keys for property " + propertyDescriptor + " of " + deployed + ". Property will be set to old value.");
                        logger.trace("Exception was: ", (Throwable)dictionaryValueException);
                    }
                }
            }
            try {
                propertyDescriptor.set(deployed, object2);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Could not convert (resolved) value to correct type for property " + propertyDescriptor + " of " + deployed + ". Property will be left empty.", (Throwable)runtimeException);
            }
        }
    }

    private Object convertToReferenceIfNeeded(Object object, PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        if (object == null) {
            return object;
        }
        if (this.optionalKind(propertyDescriptor, PropertyKind.STRING) && propertyDescriptor2.getKind() == PropertyKind.CI) {
            return this.repository.read(object.toString());
        }
        if (this.optionalKind(propertyDescriptor, PropertyKind.SET_OF_STRING) && propertyDescriptor2.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(object));
        }
        if (this.optionalKind(propertyDescriptor, PropertyKind.LIST_OF_STRING) && propertyDescriptor2.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(object));
        }
        return object;
    }

    private boolean optionalKind(PropertyDescriptor propertyDescriptor, PropertyKind propertyKind) {
        return propertyDescriptor == null || propertyDescriptor.getKind() == propertyKind;
    }

    private Collection<ConfigurationItem> getCollectionOfCis(Object object) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : (Collection)object) {
            arrayList.add(this.repository.read(string));
        }
        return arrayList;
    }

    private void setUpgradedFilePlaceholders(Deployed<?, ?> deployed, Deployable deployable, Deployed<?, ?> deployed2, ConsolidatedDictionary consolidatedDictionary) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor("placeholders");
        if (propertyDescriptor != null) {
            Map map = (Map)propertyDescriptor.get(deployed2);
            Set set = (Set)descriptor2.getPropertyDescriptor("placeholders").get((ConfigurationItem)deployable);
            propertyDescriptor.set(deployed, this.resolveFilePlaceholders(map, set, consolidatedDictionary));
        }
    }

    private Map<String, String> resolveFilePlaceholders(Map<String, String> map, Set<String> set, ConsolidatedDictionary consolidatedDictionary) {
        HashMap hashMap = Maps.newHashMap();
        for (String string : set) {
            String string2;
            try {
                string2 = consolidatedDictionary.resolve("{{" + string + "}}");
            }
            catch (DictionaryValueException dictionaryValueException) {
                string2 = map.containsKey(string) ? map.get(string) : "";
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

