/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.util.FileComparisonUtils;
import com.xebialabs.overthere.local.LocalFile;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentOperationCalculator.class);

    public static DeltaSpecificationBuilder calculate(DeltaSpecificationBuilder deltaSpecificationBuilder, Set<Deployed> set, Set<Deployed> set2) {
        Preconditions.checkNotNull(set, (Object)"Cannot calculate on null old Deployeds");
        Preconditions.checkNotNull(set2, (Object)"Cannot calculate on null new Deployeds");
        if (set.isEmpty()) {
            for (Deployed deployed : set2) {
                deltaSpecificationBuilder.create(deployed);
            }
        } else if (set2.isEmpty()) {
            for (Deployed deployed : set) {
                deltaSpecificationBuilder.destroy(deployed);
            }
        } else {
            DeploymentOperationCalculator.calculateUpgrade(deltaSpecificationBuilder, set, set2);
        }
        return deltaSpecificationBuilder;
    }

    static void calculateUpgrade(DeltaSpecificationBuilder deltaSpecificationBuilder, Set<Deployed> set, Set<Deployed> set2) {
        HashSet hashSet = Sets.newHashSet(set);
        HashSet hashSet2 = Sets.newHashSet(set2);
        for (Deployed deployed : hashSet) {
            Deployed deployed2 = DeploymentOperationCalculator.findSimilar(deployed, hashSet2);
            if (deployed2 != null) {
                hashSet2.remove(deployed2);
                if (DeploymentOperationCalculator.isDifferent(deployed, deployed2)) {
                    deltaSpecificationBuilder.modify(deployed, deployed2);
                    continue;
                }
                deltaSpecificationBuilder.noOp(deployed2);
                continue;
            }
            deltaSpecificationBuilder.destroy(deployed);
        }
        for (Deployed deployed : hashSet2) {
            deltaSpecificationBuilder.create(deployed);
        }
    }

    static Deployed findSimilar(Deployed deployed, Set<Deployed> set) {
        for (Deployed deployed2 : set) {
            if (!DeploymentOperationCalculator.isSimilar(deployed, deployed2)) continue;
            return deployed2;
        }
        return null;
    }

    static boolean isDifferent(Deployed deployed, Deployed deployed2) {
        if (!deployed.getType().equals((Object)deployed2.getType())) {
            return true;
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.getName().equals("deployable") || propertyDescriptor.getName().equals("container") || propertyDescriptor.areEqual((ConfigurationItem)deployed, (ConfigurationItem)deployed2)) continue;
            return true;
        }
        return DeploymentOperationCalculator.isDifferent(deployed.getDeployable(), deployed2.getDeployable());
    }

    static boolean isDifferent(Deployable deployable, Deployable deployable2) {
        if (!deployable.getType().equals((Object)deployable2.getType())) {
            return true;
        }
        if (DeploymentOperationCalculator.arePropertiesDifferent(deployable, deployable2)) {
            return true;
        }
        return deployable instanceof DeployableArtifact && DeploymentOperationCalculator.isDifferent((DeployableArtifact)deployable, (DeployableArtifact)deployable2);
    }

    public static boolean arePropertiesDifferent(Deployable deployable, Deployable deployable2) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.areEqual((ConfigurationItem)deployable, (ConfigurationItem)deployable2)) continue;
            return true;
        }
        return false;
    }

    static boolean isDifferent(DeployableArtifact deployableArtifact, DeployableArtifact deployableArtifact2) {
        logger.info("Checking artifact difference for {} and {}", (Object)deployableArtifact, (Object)deployableArtifact2);
        try {
            boolean bl = !FileComparisonUtils.contentEquals(((LocalFile)deployableArtifact.getFile()).getFile(), ((LocalFile)deployableArtifact2.getFile()).getFile());
            logger.info("Content different? " + bl);
            return bl;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot compare artifacts " + deployableArtifact.getId() + " and " + deployableArtifact2.getId(), iOException);
        }
    }

    static boolean isSimilar(Deployed deployed, Deployed deployed2) {
        return deployed2.getId().equals(deployed.getId()) && deployed.getType().equals((Object)deployed2.getType());
    }
}

