/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import com.xebialabs.deployit.service.gc.GarbageCollectionTask;
import com.xebialabs.deployit.task.ExecutionEngine;
import javax.jcr.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GarbageCollectionServiceImpl
implements GarbageCollectionService {
    private Repository repository;
    private ExecutionEngine executionEngine;
    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionServiceImpl.class);

    @Autowired
    public GarbageCollectionServiceImpl(Repository repository, ExecutionEngine executionEngine) {
        this.repository = repository;
        this.executionEngine = executionEngine;
    }

    @Override
    public void runGarbageCollector() {
        if (GarbageCollectionTask.isInProgress()) {
            logger.warn("Not starting new garbage collector since garbage collection already in progress");
            return;
        }
        GarbageCollectionTask garbageCollectionTask = new GarbageCollectionTask(this.repository);
        String string = this.executionEngine.register(garbageCollectionTask);
        this.executionEngine.execute(string);
    }
}

