/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.task.TaskStep;
import java.util.ArrayList;
import java.util.List;

class StepList
extends ArrayList<TaskStep> {
    private volatile int currentStepNr;

    StepList(List<? extends Step> list) {
        super(new ArrayList(Collections2.transform(list, (Function)new Function<Step, TaskStep>(){

            public TaskStep apply(Step step) {
                return new TaskStep(step);
            }
        })));
        this.currentStepNr = 0;
    }

    StepList(List<TaskStep> list, int n) {
        super(list);
        this.currentStepNr = n;
    }

    public int getNrOfSteps() {
        return this.size();
    }

    public int getCurrentStepNr() {
        return this.currentStepNr;
    }

    public TaskStep getStep(int n) {
        return (TaskStep)this.get(this.stepNumberToIndex(n));
    }

    private int stepNumberToIndex(int n) {
        if (n < 1 || n > this.getNrOfSteps()) {
            throw new IllegalArgumentException(n + " is not a valid step number");
        }
        return n - 1;
    }

    public TaskStep getNextStep() {
        return this.getStep(++this.currentStepNr);
    }

    public boolean hasMoreSteps() {
        return this.currentStepNr < this.getNrOfSteps();
    }

    public void rollback() {
        --this.currentStepNr;
    }

    public void move(int n, int n2) {
        Preconditions.checkState((this.currentStepNr == 0 ? 1 : 0) != 0, (Object)"Cannot move when iteration over StepList has started.");
        int n3 = this.stepNumberToIndex(n);
        int n4 = this.stepNumberToIndex(n2);
        TaskStep taskStep = (TaskStep)this.get(n3);
        this.remove(n3);
        this.add(n4, taskStep);
    }
}

