/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

public abstract class Option<T> {
    private static final Option<?> NONE = new None();

    public abstract boolean isSet();

    public abstract T get();

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> none() {
        return NONE;
    }

    public static class None<T>
    extends Option<T> {
        @Override
        public boolean isSet() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalArgumentException("None is not set");
        }
    }

    public static class Some<T>
    extends Option<T> {
        private T value;

        public Some(T t) {
            this.value = t;
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

