/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.util.ResourceLoader;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDTrueTypeFont.class);
    public static final String UNKNOWN_FONT = "UNKNOWN_FONT";
    private Font awtFont = null;
    private static Properties externalFonts = new Properties();
    private static Map loadedExternalFonts = new HashMap();

    public PDTrueTypeFont() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TRUE_TYPE);
    }

    public PDTrueTypeFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.ensureFontDescriptor();
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, String file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new File(file));
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, File file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream stream) throws IOException {
        PDTrueTypeFont retval = new PDTrueTypeFont();
        PDFontDescriptorDictionary fd = new PDFontDescriptorDictionary();
        retval.setFontDescriptor(fd);
        PDStream fontStream = new PDStream(doc, stream, false);
        fontStream.getStream().setInt(COSName.LENGTH1, fontStream.getByteArray().length);
        fontStream.addCompression();
        fd.setFontFile2(fontStream);
        stream = fontStream.createInputStream();
        try {
            PDTrueTypeFont.loadDescriptorDictionary(retval, fd, stream);
        }
        finally {
            stream.close();
        }
        retval.setEncoding(new WinAnsiEncoding());
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFontDescriptor() throws IOException {
        if (this.getFontDescriptor() == null) {
            PDFontDescriptorDictionary fdd = new PDFontDescriptorDictionary();
            this.setFontDescriptor(fdd);
            InputStream ttfData = this.getExternalTTFData();
            if (ttfData != null) {
                try {
                    PDTrueTypeFont.loadDescriptorDictionary(this, fdd, ttfData);
                }
                finally {
                    ttfData.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDescriptorDictionary(PDTrueTypeFont retval, PDFontDescriptorDictionary fd, InputStream ttfData) throws IOException {
        TrueTypeFont ttf = null;
        try {
            int i;
            TTFParser parser = new TTFParser();
            ttf = parser.parseTTF(ttfData);
            NamingTable naming = ttf.getNaming();
            List records = naming.getNameRecords();
            for (int i2 = 0; i2 < records.size(); ++i2) {
                NameRecord nr = (NameRecord)records.get(i2);
                if (nr.getNameId() == 6) {
                    retval.setBaseFont(nr.getString());
                    fd.setFontName(nr.getString());
                    continue;
                }
                if (nr.getNameId() != 1) continue;
                fd.setFontFamily(nr.getString());
            }
            OS2WindowsMetricsTable os2 = ttf.getOS2Windows();
            fd.setNonSymbolic(true);
            switch (os2.getFamilyClass()) {
                case 12: {
                    fd.setSymbolic(true);
                    fd.setNonSymbolic(false);
                    break;
                }
                case 10: {
                    fd.setScript(true);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    fd.setSerif(true);
                    break;
                }
            }
            switch (os2.getWidthClass()) {
                case 1: {
                    fd.setFontStretch("UltraCondensed");
                    break;
                }
                case 2: {
                    fd.setFontStretch("ExtraCondensed");
                    break;
                }
                case 3: {
                    fd.setFontStretch("Condensed");
                    break;
                }
                case 4: {
                    fd.setFontStretch("SemiCondensed");
                    break;
                }
                case 5: {
                    fd.setFontStretch("Normal");
                    break;
                }
                case 6: {
                    fd.setFontStretch("SemiExpanded");
                    break;
                }
                case 7: {
                    fd.setFontStretch("Expanded");
                    break;
                }
                case 8: {
                    fd.setFontStretch("ExtraExpanded");
                    break;
                }
                case 9: {
                    fd.setFontStretch("UltraExpanded");
                    break;
                }
            }
            fd.setFontWeight(os2.getWeightClass());
            HeaderTable header = ttf.getHeader();
            PDRectangle rect = new PDRectangle();
            rect.setLowerLeftX((float)header.getXMin() * 1000.0f / (float)header.getUnitsPerEm());
            rect.setLowerLeftY((float)header.getYMin() * 1000.0f / (float)header.getUnitsPerEm());
            rect.setUpperRightX((float)header.getXMax() * 1000.0f / (float)header.getUnitsPerEm());
            rect.setUpperRightY((float)header.getYMax() * 1000.0f / (float)header.getUnitsPerEm());
            fd.setFontBoundingBox(rect);
            HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
            fd.setAscent((float)hHeader.getAscender() * 1000.0f / (float)header.getUnitsPerEm());
            fd.setDescent((float)hHeader.getDescender() * 1000.0f / (float)header.getUnitsPerEm());
            GlyphTable glyphTable = ttf.getGlyph();
            GlyphData[] glyphs = glyphTable.getGlyphs();
            PostScriptTable ps = ttf.getPostScript();
            fd.setFixedPitch(ps.getIsFixedPitch() > 0L);
            fd.setItalicAngle(ps.getItalicAngle());
            String[] names = ps.getGlyphNames();
            if (names != null) {
                for (int i3 = 0; i3 < names.length; ++i3) {
                    if (names[i3].equals("H")) {
                        fd.setCapHeight(glyphs[i3].getBoundingBox().getUpperRightY() * 1000.0f / (float)header.getUnitsPerEm());
                    }
                    if (!names[i3].equals("x")) continue;
                    fd.setXHeight(glyphs[i3].getBoundingBox().getUpperRightY() * 1000.0f / (float)header.getUnitsPerEm());
                }
            }
            fd.setStemV(fd.getFontBoundingBox().getWidth() * 0.13f);
            CMAPTable cmapTable = ttf.getCMAP();
            CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
            int[] glyphToCCode = null;
            for (int i4 = 0; i4 < cmaps.length; ++i4) {
                if (cmaps[i4].getPlatformId() != 3 || cmaps[i4].getPlatformEncodingId() != 1) continue;
                glyphToCCode = cmaps[i4].getGlyphIdToCharacterCode();
            }
            int firstChar = 0;
            int maxWidths = glyphToCCode.length;
            HorizontalMetricsTable hMet = ttf.getHorizontalMetrics();
            int[] widthValues = hMet.getAdvanceWidth();
            ArrayList<Integer> widths = new ArrayList<Integer>(maxWidths);
            Integer zero = new Integer(250);
            for (i = 0; i < maxWidths; ++i) {
                widths.add(zero);
            }
            for (i = 0; i < widthValues.length; ++i) {
                if (glyphToCCode[i] - firstChar >= widths.size() || glyphToCCode[i] - firstChar < 0 || widths.get(glyphToCCode[i] - firstChar) != zero) continue;
                widths.set(glyphToCCode[i] - firstChar, new Integer((int)((float)widthValues[i] * 1000.0f) / header.getUnitsPerEm()));
            }
            retval.setWidths(widths);
            retval.setFirstChar(firstChar);
            retval.setLastChar(firstChar + widths.size() - 1);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    public Font getawtFont() throws IOException {
        PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
        if (this.awtFont == null) {
            PDStream ff2Stream = fd.getFontFile2();
            if (ff2Stream != null) {
                try {
                    this.awtFont = Font.createFont(0, ff2Stream.createInputStream());
                }
                catch (FontFormatException f) {
                    log.info((Object)("Can't read the embedded font " + fd.getFontName()));
                }
                if (this.awtFont == null) {
                    this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    if (this.awtFont != null) {
                        log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
                    }
                }
            } else {
                this.awtFont = FontManager.getAwtFont(fd.getFontName());
                if (this.awtFont == null) {
                    log.info((Object)("Can't find the specified font " + fd.getFontName()));
                    TrueTypeFont ttf = this.getExternalFontFile2(fd);
                    if (ttf != null) {
                        try {
                            this.awtFont = Font.createFont(0, ttf.getOriginalData());
                        }
                        catch (FontFormatException f) {
                            log.info((Object)("Can't read the external fontfile " + fd.getFontName()));
                        }
                    }
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info((Object)("Using font " + this.awtFont.getName() + " instead"));
            }
        }
        return this.awtFont;
    }

    private InputStream getExternalTTFData() throws IOException {
        String ttfResource = externalFonts.getProperty(UNKNOWN_FONT);
        String baseFont = this.getBaseFont();
        if (baseFont != null && externalFonts.containsKey(baseFont)) {
            ttfResource = externalFonts.getProperty(baseFont);
        }
        return ttfResource != null ? ResourceLoader.loadResource(ttfResource) : null;
    }

    private TrueTypeFont getExternalFontFile2(PDFontDescriptorDictionary fd) throws IOException {
        TrueTypeFont retval = null;
        if (fd != null) {
            String baseFont = this.getBaseFont();
            String fontResource = externalFonts.getProperty(UNKNOWN_FONT);
            if (baseFont != null && externalFonts.containsKey(baseFont)) {
                fontResource = externalFonts.getProperty(baseFont);
            }
            if (fontResource != null && (retval = (TrueTypeFont)loadedExternalFonts.get(baseFont)) == null) {
                TTFParser ttfParser = new TTFParser();
                InputStream fontStream = ResourceLoader.loadResource(fontResource);
                if (fontStream == null) {
                    throw new IOException("Error missing font resource '" + externalFonts.get(baseFont) + "'");
                }
                retval = ttfParser.parseTTF(fontStream);
                loadedExternalFonts.put(baseFont, retval);
            }
        }
        return retval;
    }

    static {
        try {
            ResourceLoader.loadProperties("org/apache/pdfbox/resources/PDFBox_External_Fonts.properties", externalFonts);
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading font resources", io);
        }
    }
}

