/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.execution;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.InterleavedPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.ParallelPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.SerialPlan;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import java.util.List;

public class Plans {
    public static InterleavedPlan interleaved(List<Delta> list) {
        return new InterleavedPlan(list);
    }

    public static InterleavedPlan interleaved(Delta ... deltaArray) {
        return new InterleavedPlan(deltaArray);
    }

    public static ParallelPlan parallel(Plan ... planArray) {
        return new ParallelPlan(planArray);
    }

    public static ParallelPlan parallel(List<Plan> list) {
        return new ParallelPlan(list);
    }

    public static SerialPlan serial(Plan ... planArray) {
        return new SerialPlan(planArray);
    }

    public static SerialPlan serial(List<Plan> list) {
        return new SerialPlan(list);
    }

    public static InterleavedPlan interleaved(ListMultimap<Integer, DeploymentStep> listMultimap) {
        return new InterleavedPlan(Lists.newArrayList(), listMultimap);
    }

    public static InterleavedPlanBuilder newInterleavedPlan(InterleavedPlan interleavedPlan) {
        return new InterleavedPlanBuilder(interleavedPlan);
    }

    public static class InterleavedPlanBuilder {
        private List<Delta> operations;
        private ListMultimap<Integer, DeploymentStep> steps;

        private InterleavedPlanBuilder(InterleavedPlan interleavedPlan) {
            this.operations = interleavedPlan.getDeltas();
            this.steps = ArrayListMultimap.create(interleavedPlan.getStepsMap());
        }

        public InterleavedPlanBuilder withStep(DeploymentStep deploymentStep) {
            this.steps.put((Object)deploymentStep.getOrder(), (Object)deploymentStep);
            return this;
        }

        public InterleavedPlanBuilder withSteps(List<DeploymentStep> list) {
            for (DeploymentStep deploymentStep : list) {
                this.steps.put((Object)deploymentStep.getOrder(), (Object)deploymentStep);
            }
            return this;
        }

        public InterleavedPlanBuilder withSteps(DeploymentStep ... deploymentStepArray) {
            for (DeploymentStep deploymentStep : deploymentStepArray) {
                this.steps.put((Object)deploymentStep.getOrder(), (Object)deploymentStep);
            }
            return this;
        }

        public InterleavedPlanBuilder replaceAllSteps(ListMultimap<Integer, DeploymentStep> listMultimap) {
            this.steps = listMultimap;
            return this;
        }

        public InterleavedPlan build() {
            return new InterleavedPlan(this.operations, this.steps);
        }
    }
}

