/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ArtifactDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationItemDtoWriter {
    public ConfigurationItemDtos write(Collection<ConfigurationItem> collection) {
        ConfigurationItemDtos configurationItemDtos = new ConfigurationItemDtos();
        for (ConfigurationItem configurationItem : collection) {
            configurationItemDtos.add(this.write(configurationItem));
        }
        return configurationItemDtos;
    }

    public ConfigurationItemDto write(ConfigurationItem configurationItem) {
        ArtifactDto artifactDto;
        if (configurationItem instanceof Artifact) {
            artifactDto = new ArtifactDto(configurationItem.getType().toString());
            artifactDto.setId(configurationItem.getId());
            OverthereFile overthereFile = ((Artifact)configurationItem).getFile();
            if (overthereFile != null) {
                artifactDto.setFilename(overthereFile.getName());
            }
        } else {
            artifactDto = new ConfigurationItemDto(configurationItem.getId(), configurationItem.getType().toString());
        }
        this.copyValues(configurationItem, (ConfigurationItemDto)artifactDto);
        return artifactDto;
    }

    private void copyValues(ConfigurationItem configurationItem, ConfigurationItemDto configurationItemDto) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object object = propertyDescriptor.get(configurationItem);
            if (object == null) continue;
            switch (propertyDescriptor.getKind()) {
                case STRING: {
                    if (propertyDescriptor.isPassword()) {
                        object = PasswordObfuscator.ensureEncrypted((String)((String)object));
                    }
                }
                case BOOLEAN: 
                case INTEGER: 
                case ENUM: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)object.toString());
                    break;
                }
                case SET_OF_STRING: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)Sets.newHashSet((Iterable)((Collection)object)));
                    break;
                }
                case SET_OF_CI: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)Sets.newHashSet(this.transformCollectionOfCi((Collection)object)));
                    break;
                }
                case LIST_OF_STRING: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)Lists.newArrayList((Iterable)((Collection)object)));
                    break;
                }
                case LIST_OF_CI: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)Lists.newArrayList(this.transformCollectionOfCi((Collection)object)));
                    break;
                }
                case CI: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)((ConfigurationItem)object).getId());
                    break;
                }
                case MAP_STRING_STRING: {
                    configurationItemDto.setProperty(propertyDescriptor.getName(), (Object)Maps.newHashMap((Map)((Map)object)));
                }
            }
        }
    }

    private Collection<String> transformCollectionOfCi(Collection<ConfigurationItem> collection) {
        return Collections2.transform(collection, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem configurationItem) {
                return configurationItem.getId();
            }
        });
    }

    public ConfigurationItemDto write(ConfigurationItem configurationItem, Iterable<ValidationMessage> iterable) {
        ConfigurationItemDto configurationItemDto = this.write(configurationItem);
        for (ValidationMessage validationMessage : iterable) {
            configurationItemDto.addValidation(new Message(validationMessage.getPropertyName(), validationMessage.getMessage()));
        }
        return configurationItemDto;
    }

    public List<ConfigurationItemDto> write(ListMultimap<Boolean, ConfigurationItem> listMultimap) {
        ConfigurationItemDto configurationItemDto;
        Checks.checkNotNull(listMultimap, (String)"deployeds");
        ArrayList arrayList = Lists.newArrayList();
        for (ConfigurationItem configurationItem : listMultimap.get((Object)true)) {
            configurationItemDto = this.write(configurationItem);
            arrayList.add(configurationItemDto);
        }
        for (ConfigurationItem configurationItem : listMultimap.get((Object)false)) {
            configurationItemDto = this.write(configurationItem);
            ArrayList<Message> arrayList2 = new ArrayList<Message>();
            arrayList2.add(new Message("source", "The deployable for this deployed is missing from the package."));
            configurationItemDto.setValidations(arrayList2);
            arrayList.add(configurationItemDto);
        }
        return arrayList;
    }
}

