/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.ReportFilterType;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class AggregatedDeploymentsKeyIndicator {
    private TaskArchive taskArchive;

    public AggregatedDeploymentsKeyIndicator(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(Date date, Date date2, final ReportFilterType reportFilterType, List<ConfigurationItemId> list) {
        final ConcurrentMap concurrentMap = new MapMaker().makeComputingMap((Function)new Function<String, TaskStateData>(){

            public TaskStateData apply(String string) {
                return new TaskStateData();
            }
        });
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters();
        archivedTaskSearchParameters.createdBetween(date.getCalendar(), date2.getCalendar());
        for (ConfigurationItemId configurationItemId : list) {
            switch (reportFilterType) {
                case APPLICATION: {
                    archivedTaskSearchParameters.forApplication(configurationItemId.getId());
                    break;
                }
                case ENVIRONMENT: {
                    archivedTaskSearchParameters.toEnvironment(configurationItemId.getId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Report filter type, " + (Object)((Object)reportFilterType) + " is not supported");
                }
            }
            this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(DeploymentTaskInfo deploymentTaskInfo) {
                    AggregatedDeploymentsKeyIndicator.this.fillTasksMap(concurrentMap, deploymentTaskInfo, reportFilterType);
                }
            });
        }
        return this.generateReportDataFromTaskMap(concurrentMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> map) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : map.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("entityName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
            reportLine.addValue("noOfFailedDeployments", (Object)entry.getValue().getNoOfFailedDeployments().toString());
            reportLine.addValue("noOfAbortedDeployments", (Object)entry.getValue().getNoOfAbortedDeployments().toString());
            String string = "00:00:00";
            if (entry.getValue().getTotalSuccessfulTasks() > 0) {
                string = ReportUtils.formatToHoursMinsSecs(entry.getValue().getAverageDeploymentTime() / (long)entry.getValue().getTotalSuccessfulTasks());
            }
            reportLine.addValue("averageDuration", (Object)string);
        }
        return report;
    }

    private void fillTasksMap(Map<String, TaskStateData> map, DeploymentTaskInfo deploymentTaskInfo, ReportFilterType reportFilterType) {
        String string = this.getEntityId(deploymentTaskInfo, reportFilterType);
        TaskStateData taskStateData = map.get(string);
        taskStateData.addTaskAndDuration(deploymentTaskInfo);
    }

    private String getEntityId(DeploymentTaskInfo deploymentTaskInfo, ReportFilterType reportFilterType) {
        switch (reportFilterType) {
            case APPLICATION: {
                return deploymentTaskInfo.getApplicationName();
            }
            case ENVIRONMENT: {
                return deploymentTaskInfo.getEnvironment();
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)reportFilterType));
    }
}

