/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class DeployitExceptionMapper
extends ClosingExceptionMapper<DeployitException>
implements ExceptionMapper<DeployitException> {
    private static final Logger logger = LoggerFactory.getLogger(DeployitExceptionMapper.class);

    @Override
    public Response handleException(DeployitException deployitException) {
        logger.info("Intercepting DeployitException", (Throwable)deployitException);
        HttpResponseCodeResult httpResponseCodeResult = deployitException.getClass().getAnnotation(HttpResponseCodeResult.class);
        int n = 500;
        if (httpResponseCodeResult != null) {
            n = httpResponseCodeResult.statusCode();
        }
        Response.ResponseBuilder responseBuilder = ResponseFactory.status((int)n).type("application/xml");
        responseBuilder.header("Deployit-Exception", (Object)"true");
        responseBuilder.header("Exception-Type", (Object)deployitException.getClass().getName());
        Response response = responseBuilder.entity((Object)Sanitizer.sanitize(Exceptions.getAllMessages((Exception)deployitException))).build();
        logger.info("Returning response {}", (Object)response);
        return response;
    }
}

