/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceContentServlet
extends DefaultServlet {
    private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebialabs.deployit.jetty.ClassPathResourceContentServlet.fallbackDirectory";
    private final String packageName;
    private final boolean fallbackToDevelopmentResources;
    private final String fallbackDirectory;
    private static final Logger logger = LoggerFactory.getLogger(ClassPathResourceContentServlet.class);

    public ClassPathResourceContentServlet(String string) {
        assert (string != null);
        this.packageName = string.replace('.', '/');
        this.fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
        boolean bl = this.fallbackToDevelopmentResources = !Strings.isNullOrEmpty((String)this.fallbackDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug("Using " + this.packageName + " as the document root on the classpath (fallbackToDevelopmentResources=" + this.fallbackToDevelopmentResources + ").");
        }
    }

    public Resource getResource(String string) {
        string = string.replace("-@project.version@", "");
        String string2 = "/" + this.packageName + string;
        if (logger.isDebugEnabled()) {
            logger.debug("Requested resource " + string2 + " to load");
        }
        URL uRL = ((Object)((Object)this)).getClass().getResource(string2);
        try {
            Resource resource = Resource.newResource((URL)uRL);
            if ((resource == null || !resource.exists()) && this.fallbackToDevelopmentResources) {
                String string3 = "file:" + this.fallbackDirectory + string;
                if (logger.isInfoEnabled()) {
                    logger.info("Cannot find " + string2 + " in classpath, falling back to URL " + string3);
                }
                resource = Resource.newResource((String)string3);
            }
            if (resource == null || !resource.exists()) {
                if (string2.endsWith(".gz")) {
                    logger.debug("Cannot find " + string2 + " in classpath");
                } else {
                    logger.error("Cannot find " + string2 + " in classpath");
                }
            }
            return resource;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

