/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.jetty.HttpMethodOverrideServletRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodOverrideFilter
implements Filter {
    public static final String HEADER_PARAM = "methodOverrideHeader";
    private String header;
    private static Logger logger = LoggerFactory.getLogger(MethodOverrideFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.header = filterConfig.getInitParameter(HEADER_PARAM);
        if (this.header == null || this.header.length() == 0) {
            this.header = "X-HTTP-Method-Override";
        }
        logger.info("Initialized to check for header {}", (Object)this.header);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        ServletRequest servletRequest2 = servletRequest;
        if (servletRequest instanceof HttpServletRequest) {
            servletRequest2 = this.processRequest(servletRequest);
        }
        filterChain.doFilter(servletRequest2, servletResponse);
    }

    protected ServletRequest processRequest(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        return new HttpMethodOverrideServletRequest(httpServletRequest, this.header);
    }
}

