/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.TunneledResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunneledResponseBuilder
extends Response.ResponseBuilder {
    private TunneledResponse tunneledResponse = new TunneledResponse();
    private Headers<Object> metadata = new Headers();
    private static final Map<Class<?>, JAXBContext> CONTEXT_MAP = new MapMaker().makeComputingMap(new Function<Class<?>, JAXBContext>(){

        public JAXBContext apply(Class<?> clazz) {
            try {
                return JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (JAXBException jAXBException) {
                throw new RuntimeException(jAXBException);
            }
        }
    });
    private static final Logger logger = LoggerFactory.getLogger(TunneledResponseBuilder.class);

    public Response build() {
        return new ServerResponse((Object)this.tunneledResponse, 200, this.metadata);
    }

    public Response.ResponseBuilder clone() {
        TunneledResponseBuilder tunneledResponseBuilder = new TunneledResponseBuilder();
        tunneledResponseBuilder.tunneledResponse = this.tunneledResponse;
        tunneledResponseBuilder.metadata.putAll(this.metadata);
        return tunneledResponseBuilder;
    }

    public Response.ResponseBuilder status(int n) {
        logger.debug("Setting status: {}", (Object)n);
        this.tunneledResponse.setStatus(n);
        return this;
    }

    public Response.ResponseBuilder entity(Object object) {
        logger.trace("Setting entity: {}", object);
        if (object == null) {
            return this;
        }
        if (object.getClass().getAnnotation(XmlRootElement.class) != null) {
            StringWriter stringWriter = new StringWriter();
            try {
                JAXBContext jAXBContext = CONTEXT_MAP.get(object.getClass());
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)true);
                marshaller.marshal(object, (Writer)stringWriter);
            }
            catch (JAXBException jAXBException) {
                throw new IllegalArgumentException("Could not marshal: " + object, jAXBException);
            }
            this.tunneledResponse.setEntity(stringWriter.toString());
        } else {
            this.tunneledResponse.setEntity(object.toString());
        }
        return this;
    }

    public Response.ResponseBuilder type(MediaType mediaType) {
        return this.addSingleHeader("Content-Type", mediaType);
    }

    public Response.ResponseBuilder type(String string) {
        return this.addSingleHeader("Content-Type", string);
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant.getMediaType() != null) {
            this.type(variant.getMediaType());
        }
        if (variant.getLanguage() != null) {
            this.language(variant.getLanguage());
        }
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", (Object)variant.getEncoding());
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> list) {
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    public Response.ResponseBuilder language(String string) {
        return this.addSingleHeader("Content-Language", string);
    }

    public Response.ResponseBuilder language(Locale locale) {
        return this.addSingleHeader("Content-Language", locale);
    }

    public Response.ResponseBuilder location(URI uRI) {
        return this.addSingleHeader("Location", this.absolutize(uRI));
    }

    public Response.ResponseBuilder contentLocation(URI uRI) {
        return this.addSingleHeader("Content-Location", this.absolutize(uRI));
    }

    private URI absolutize(URI uRI) {
        if (!uRI.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String string = uRI.toString();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            URI uRI2 = ((HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class)).getUri().getBaseUri();
            uRI = uRI2.resolve(string);
        }
        return uRI;
    }

    public Response.ResponseBuilder tag(EntityTag entityTag) {
        return this.addSingleHeader("ETag", entityTag);
    }

    public Response.ResponseBuilder tag(String string) {
        return this.addSingleHeader("ETag", string);
    }

    public Response.ResponseBuilder lastModified(Date date) {
        return this.addSingleHeader("Last-Modified", DateUtil.formatDate((Date)date));
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        return this.addSingleHeader("Cache-Control", cacheControl);
    }

    public Response.ResponseBuilder expires(Date date) {
        return this.addSingleHeader("Expires", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(date));
    }

    public Response.ResponseBuilder header(String string, Object object) {
        return this.addHeader(string, object);
    }

    public Response.ResponseBuilder cookie(NewCookie ... newCookieArray) {
        logger.debug("Setting cookies: {}", (Object[])newCookieArray);
        if (newCookieArray == null) {
            this.metadata.remove((Object)"Set-Cookie");
            return this;
        }
        for (NewCookie newCookie : newCookieArray) {
            this.metadata.add("Set-Cookie", (Object)newCookie);
        }
        return this;
    }

    private Response.ResponseBuilder addSingleHeader(String string, Object object) {
        logger.debug("Adding header: {}: {}", (Object)string, object);
        this.metadata.putSingle(string, object);
        this.tunneledResponse.addSingleHeader(string, object);
        return this;
    }

    private Response.ResponseBuilder addHeader(String string, Object object) {
        logger.debug("Adding header: {}: {}", (Object)string, object);
        this.metadata.add(string, object);
        this.tunneledResponse.addHeader(string, object);
        return this;
    }
}

