/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.value.StringValue;

public class JcrUtils {
    public static Map<String, String> readMap(Property property) throws RepositoryException {
        HashMap hashMap = Maps.newHashMap();
        Preconditions.checkState((boolean)property.isMultiple(), (String)"The property [%s] should be multi-valued in order to read a Map<String, String>", (Object[])new Object[]{property.getName()});
        for (Value value : property.getValues()) {
            String string = value.getString();
            int n = string.indexOf("=");
            String string2 = string;
            String string3 = "";
            if (n > -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static void writeMap(Node node, String string, Map<String, String> map) throws RepositoryException {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(new StringValue(entry.getKey() + "=" + entry.getValue()));
        }
        node.setProperty(string, arrayList.toArray(new Value[arrayList.size()]));
    }

    public static void forEachNonJcrProperty(Node node, Callback<Property> callback) throws RepositoryException {
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (property.getName().startsWith("jcr:") || property.getName().startsWith("$")) continue;
            callback.apply(property);
        }
    }

    public static void clearProperties(Node node) throws RepositoryException {
        JcrUtils.forEachNonJcrProperty(node, new Callback<Property>(){

            @Override
            public void apply(Property property) throws RepositoryException {
                property.remove();
            }
        });
    }

    public static interface Callback<T> {
        public void apply(T var1) throws RepositoryException;
    }
}

