/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.util.Option;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class PermissionEnforcer {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    private JcrTemplate jcrTemplate;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermissionEnforcer.class);

    @Autowired
    public PermissionEnforcer(JcrTemplate jcrTemplate, RoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public boolean hasPermission(Authentication authentication, Permission ... permissionArray) {
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissionArray), "");
    }

    public boolean hasLoggedInUserPermission(Permission ... permissionArray) {
        Authentication authentication = Permissions.getAuthentication();
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissionArray), "");
    }

    public boolean hasLoggedInUserPermission(Permission permission, String string) {
        return this.hasLoggedInUserPermission(Lists.newArrayList((Object[])new Permission[]{permission}), string);
    }

    public boolean hasLoggedInUserPermission(List<Permission> list, String string) {
        return this.hasPermission(Permissions.getAuthentication(), list, string);
    }

    private boolean hasPermission(Authentication authentication, List<Permission> list, String string) {
        List<Role> list2;
        Collection<String> collection = Permissions.authenticationToPrincipals(authentication);
        if (this.isAdmin(collection, list2 = this.roleService.getRolesFor(authentication))) {
            return true;
        }
        return this.checkPermission(list, string, list2);
    }

    private boolean checkPermission(final List<Permission> list, final String string, final List<Role> list2) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                if (Strings.nullToEmpty((String)string).isEmpty()) {
                    return PermissionEnforcer.this.checkGlobalPermission(session, list, list2);
                }
                return PermissionEnforcer.this.checkCiPermission(session, list, string, list2);
            }
        });
    }

    private boolean checkGlobalPermission(Session session, List<Permission> list, List<Role> list2) throws RepositoryException {
        Node node = session.getNode("/$configuration/security");
        Option<Boolean> option = this.checkPermission(node, list, list2);
        if (option.isSet()) {
            return option.get();
        }
        return false;
    }

    private boolean checkCiPermission(Session session, List<Permission> list, String string, List<Role> list2) throws RepositoryException {
        List<String> list3 = this.nodesToInspect(string);
        for (String string2 : list3) {
            Option<Boolean> option;
            if (!session.nodeExists(string2) || !(option = this.checkCiPermission(session.getNode(string2), list, list2)).isSet()) continue;
            return option.get();
        }
        return false;
    }

    private Option<Boolean> checkCiPermission(Node node, List<Permission> list, List<Role> list2) throws RepositoryException {
        if (!Permissions.isSecurable(node)) {
            return Option.none();
        }
        return this.checkPermission(node, list, list2);
    }

    private Option<Boolean> checkPermission(Node node, List<Permission> list, List<Role> list2) throws RepositoryException {
        logger.debug("Trying to read permissions from [{}]", (Object)node.getPath());
        Map<String, String> map = Permissions.readPermissionMap(node);
        if (map.isEmpty()) {
            logger.debug("[{}] has no permissions set, checking up the tree.", (Object)node.getPath());
            return Option.none();
        }
        logger.debug("[{}] has permissions enabled, which are: [{}]", (Object)node.getPath(), map);
        for (Permission permission : list) {
            Iterable<Integer> iterable;
            if (!map.containsKey(permission.getPermissionName()) || !Iterables.any(iterable = Permissions.splitRoles(map.get(permission.getPermissionName())), (Predicate)Predicates.in((Collection)Lists.newArrayList(Permissions.rolesToIds(list2))))) continue;
            return Option.some(true);
        }
        return Option.some(false);
    }

    private List<String> nodesToInspect(String string) {
        return Lists.newArrayList((Iterable)Lists.transform(Permissions.getFullTreeAsSeparateNodesInChildToRootOrder(string), (Function)new Function<String, String>(){

            public String apply(String string) {
                return JcrPathHelper.getAbsolutePathFromId(string);
            }
        }));
    }

    boolean isAdmin(Collection<String> collection, List<Role> list) {
        Boolean bl = collection.contains(ROLE_ADMIN) || this.checkPermission(Lists.newArrayList((Object[])new Permission[]{Permission.ADMIN}), "", list);
        logger.debug("Admin privileges [{}] granted to {}", (Object)(bl != false ? "are" : "are not"), collection);
        return bl;
    }
}

