/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.GrantedAuthorityImpl;

public class JcrAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(JcrAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        logger.debug("Authenticating for Deployit: {}", authentication.getPrincipal());
        String string = authentication.getPrincipal().toString();
        String string2 = authentication.getCredentials().toString();
        return this.doAuthentication(string, string2);
    }

    private Authentication doAuthentication(final String string, final String string2) {
        if (Strings.nullToEmpty((String)string).trim().isEmpty()) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        try {
            logger.trace("Authenticating [{}]", (Object)string);
            return this.jcrTemplate.execute(new JcrCallback<Authentication>(){

                @Override
                public Authentication doInJcr(Session session) throws IOException, RepositoryException {
                    UserManager userManager = ((JackrabbitSession)session).getUserManager();
                    User user = (User)userManager.getAuthorizable(string);
                    if (user == null) {
                        throw new AuthenticationFailureException("User with username [%s] does not exist,", string);
                    }
                    Credentials credentials = user.getCredentials();
                    JcrAuthenticationProvider.this.validateCredentials(credentials, string, string2);
                    ArrayList arrayList = Lists.newArrayList();
                    if (user.isAdmin()) {
                        arrayList.add(new GrantedAuthorityImpl("ROLE_ADMIN"));
                    }
                    UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)string, (Object)string2, (Collection)arrayList);
                    return usernamePasswordAuthenticationToken;
                }
            });
        }
        catch (AuthenticationFailureException authenticationFailureException) {
            throw new BadCredentialsException("Cannot authenticate " + string, (Throwable)authenticationFailureException);
        }
    }

    private void validateCredentials(Credentials credentials, String string, String string2) throws UnsupportedEncodingException {
        Preconditions.checkState((boolean)(credentials instanceof CryptedSimpleCredentials), (Object)"Should have an instance of CryptedSimpleCredentials");
        try {
            if (!((CryptedSimpleCredentials)credentials).matches(new SimpleCredentials(string, string2.toCharArray()))) {
                throw new AuthenticationFailureException("Wrong credentials supplied for user [%s]", string);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationFailureException(noSuchAlgorithmException);
        }
    }

    public boolean supports(Class<? extends Object> clazz) {
        return clazz.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }
}

