/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.xebialabs.deployit.event.EventBus;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.Registry;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javassist.util.proxy.ProxyObjectInputStream;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.context.SecurityContextHolder;

public class ArchivingTaskRegistry
implements TaskRegistry {
    @Autowired
    private TaskArchive taskArchive;
    @Autowired
    private RepositoryService repositoryService;
    private File recoveryFile;
    private int recoveryFileWritingIntervalMillis;
    private Registry registry = new Registry();
    private EventCallback<Task.TaskStateChangeEvent> taskArchivingCallback;
    private Timer recoveryFileWritingTimer;
    private static final Logger logger = LoggerFactory.getLogger(ArchivingTaskRegistry.class);

    @Required
    public void setRecoveryFile(File file) {
        this.recoveryFile = file;
    }

    @Required
    public void setRecoveryFileWritingIntervalMillis(int n) {
        this.recoveryFileWritingIntervalMillis = n;
    }

    @Override
    public String registerTask(Task task) {
        String string = UUID.randomUUID().toString();
        task.setId(string);
        this.registry.register(task);
        return string;
    }

    @Override
    public Task getTask(String string) {
        return this.registry.retrieve(string);
    }

    @Override
    public void cancelTask(String string) {
        Task task = this.getTask(string);
        if (task.isReadyForExecution() || task.getState() == Task.State.PENDING) {
            boolean bl = false;
            if (task.getState().equals((Object)Task.State.STOPPED)) {
                bl = true;
            }
            task.cancel();
            if (bl) {
                this.moveTaskFromRegistryToArchive(task);
            }
            this.registry.remove(string);
        }
    }

    @Override
    public Collection<Task> getTasks() {
        return this.registry.tasks();
    }

    @Override
    public List<Task> getIncompleteTasksForUser(String string) {
        logger.debug("Finding incomplete tasks for user [{}]", (Object)string);
        ArrayList arrayList = Lists.newArrayList();
        for (Task task : this.getAllIncompleteTasks()) {
            if (!task.getOwner().equals(string)) continue;
            arrayList.add(task);
        }
        logger.debug("Returning [{}] tasks", (Object)arrayList.size());
        return arrayList;
    }

    @Override
    public List<Task> getAllIncompleteTasks() {
        logger.debug("Finding all incomplete tasks");
        ArrayList arrayList = Lists.newArrayList();
        for (Task task : this.registry.tasks()) {
            logger.debug("Considering task {}", (Object)task);
            if (!task.getState().equals((Object)Task.State.PENDING) && !task.getState().equals((Object)Task.State.QUEUED) && !task.getState().equals((Object)Task.State.STOPPED) && !task.getState().equals((Object)Task.State.EXECUTING)) continue;
            logger.debug("Returning task [{}] because it's PENDING, STOPPED or EXECUTING", (Object)task);
            arrayList.add(task);
        }
        logger.debug("Returning [{}] tasks", (Object)arrayList.size());
        return arrayList;
    }

    @Override
    public void assignTask(String string, String string2) {
        logger.debug("Assigning task [{}] to owner [{}]", (Object)string, (Object)string2);
        Task task = this.getTask(string);
        task.setOwner(string2);
    }

    @Override
    public void assignMyTask(String string, String string2) {
        Task task = this.getTask(string);
        if (!task.getOwner().equals(SecurityContextHolder.getContext().getAuthentication().getName())) {
            throw PermissionDeniedException.withMessage("You are not the current owner of task " + string);
        }
        this.assignTask(string, string2);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.loadTasksFromRecoveryFile();
        this.registerTaskArchivingCallback();
        this.startRecoveryFileWritingTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTasksFromRecoveryFile() {
        if (this.recoveryFile != null && this.recoveryFile.exists()) {
            try {
                ProxyObjectInputStream proxyObjectInputStream = new ProxyObjectInputStream((InputStream)new FileInputStream(this.recoveryFile));
                try {
                    this.registry.recover((ObjectInputStream)proxyObjectInputStream);
                    this.postprocessTaskRegistryAfterRecovery();
                }
                finally {
                    proxyObjectInputStream.close();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("Cannot load tasks from recovery file " + this.recoveryFile, (Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                logger.error("Cannot load tasks from recovery file " + this.recoveryFile, (Throwable)iOException);
            }
        }
    }

    private void postprocessTaskRegistryAfterRecovery() {
        Iterator<Task> iterator = this.registry.tasks().iterator();
        if (iterator.hasNext()) {
            logger.info("Recovering tasks after server crash");
            while (iterator.hasNext()) {
                Task task = iterator.next();
                Task.State state = task.getState();
                if (state == Task.State.PENDING) {
                    logger.info("Removing {} task {}", (Object)state, (Object)task.getId());
                    iterator.remove();
                    continue;
                }
                logger.info("Recovering {} task {}", (Object)state, (Object)task.getId());
                this.setDepedenciesInTask(task);
                task.processAfterRecovery();
            }
            logger.info("Recovered tasks after server crash");
        }
    }

    private void setDepedenciesInTask(Task task) {
        DirectFieldAccessor directFieldAccessor;
        if (!task.getState().equals((Object)Task.State.PENDING) && (directFieldAccessor = new DirectFieldAccessor((Object)task)).isWritableProperty("repositoryService")) {
            directFieldAccessor.setPropertyValue("repositoryService", (Object)this.repositoryService);
        }
    }

    @Override
    public void destroy() {
        this.stopRecoveryFileWritingTimer();
        this.writeRecoveryFile();
        this.deregisterTaskArchivingCallback();
    }

    private void registerTaskArchivingCallback() {
        this.taskArchivingCallback = new EventCallback<Task.TaskStateChangeEvent>(){

            @Override
            public void receive(Task.TaskStateChangeEvent taskStateChangeEvent) {
                Task task = taskStateChangeEvent.getTask();
                if (task.getState().equals((Object)Task.State.DONE)) {
                    ArchivingTaskRegistry.this.moveTaskFromRegistryToArchive(task);
                }
            }
        };
        EventBus.registerForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void deregisterTaskArchivingCallback() {
        EventBus.deregisterForEvent(Task.TaskStateChangeEvent.class, this.taskArchivingCallback);
    }

    private void startRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer = new Timer(ArchivingTaskRegistry.class.getName() + "#recoveryFileWritingTimer", true);
        this.recoveryFileWritingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ArchivingTaskRegistry.this.writeRecoveryFile();
            }
        }, this.recoveryFileWritingIntervalMillis, (long)this.recoveryFileWritingIntervalMillis);
    }

    private void stopRecoveryFileWritingTimer() {
        this.recoveryFileWritingTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void writeRecoveryFile() {
        block8: {
            if (this.recoveryFile != null) {
                try {
                    if (this.registry.hasInProgressTasks()) {
                        logger.debug("Writing task recovery file.");
                        File file = new File(this.recoveryFile.getParentFile(), "recovery.tmp");
                        ProxyObjectOutputStream proxyObjectOutputStream = new ProxyObjectOutputStream((OutputStream)new FileOutputStream(file));
                        try {
                            this.registry.writeRecovery((ObjectOutputStream)proxyObjectOutputStream);
                        }
                        finally {
                            proxyObjectOutputStream.close();
                        }
                        this.deleteRecoveryFile();
                        Files.move((File)file, (File)this.recoveryFile);
                        break block8;
                    }
                    this.deleteRecoveryFile();
                }
                catch (IOException iOException) {
                    logger.error("Cannot write task registry recovery file", (Throwable)iOException);
                }
            }
        }
    }

    protected void deleteRecoveryFile() {
        if (this.recoveryFile.exists()) {
            try {
                Files.deleteRecursively((File)this.recoveryFile);
            }
            catch (IOException iOException) {
                logger.error("Could not delete {}", (Object)this.recoveryFile, (Object)iOException);
            }
        }
    }

    private void moveTaskFromRegistryToArchive(final Task task) {
        Preconditions.checkNotNull((Object)task.getOwnerCredentials(), (Object)("Cannot archive task " + task.getId() + " because it has no owner"));
        SecurityTemplate.executeAs(task.getOwnerCredentials(), new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                if (task instanceof DeploymentTask) {
                    ArchivingTaskRegistry.this.taskArchive.archiveTask((DeploymentTask)task);
                }
                ArchivingTaskRegistry.this.registry.remove(task.getId());
                return null;
            }
        });
    }

    @Override
    public TaskArchive getTaskArchive() {
        return this.taskArchive;
    }
}

