/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;

public class GuavaFiles {
    public static void deleteDirectoryContents(File file) throws IOException {
        Preconditions.checkArgument((boolean)file.isDirectory(), (String)"Not a directory: %s", (Object[])new Object[]{file});
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Error listing files for " + file);
        }
        for (File file2 : fileArray) {
            GuavaFiles.deleteRecursively(file2);
        }
    }

    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            GuavaFiles.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static void deleteQuietly(File file) {
        try {
            GuavaFiles.deleteRecursively(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

