/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Calendar;
import java.util.HashSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InconsistentVersioningState;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryChecker {
    private static final Logger log = LoggerFactory.getLogger(RepositoryChecker.class);
    private final PersistenceManager workspace;
    private final ChangeLog workspaceChanges;
    private final ChangeLog vworkspaceChanges;
    private final InternalVersionManagerImpl versionManager;

    public RepositoryChecker(PersistenceManager workspace, InternalVersionManagerImpl versionManager) {
        this.workspace = workspace;
        this.workspaceChanges = new ChangeLog();
        this.vworkspaceChanges = new ChangeLog();
        this.versionManager = versionManager;
    }

    public void check(NodeId id, boolean recurse) throws RepositoryException {
        try {
            log.debug("Checking consistency of node {}", (Object)id);
            NodeState state = this.workspace.load(id);
            this.checkVersionHistory(state);
            if (recurse) {
                for (ChildNodeEntry child : state.getChildNodeEntries()) {
                    if (RepositoryImpl.SYSTEM_ROOT_NODE_ID.equals(child.getId())) continue;
                    this.check(child.getId(), recurse);
                }
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to access node " + id, (Throwable)e);
        }
    }

    private void fix(PersistenceManager pm, ChangeLog changes, String store) throws RepositoryException {
        if (changes.hasUpdates()) {
            log.warn("Fixing " + store + " inconsistencies");
            try {
                pm.store(changes);
            }
            catch (ItemStateException e) {
                String message = "Failed to fix " + store + " inconsistencies (aborting)";
                log.error(message, (Throwable)e);
                throw new RepositoryException(message, (Throwable)e);
            }
        } else {
            log.info("No " + store + "  inconsistencies found");
        }
    }

    public void fix() throws RepositoryException {
        this.fix(this.workspace, this.workspaceChanges, "workspace");
        this.fix(this.versionManager.getPersistenceManager(), this.vworkspaceChanges, "versioning workspace");
    }

    private void checkVersionHistory(NodeState node) {
        String message = null;
        NodeId nid = node.getNodeId();
        boolean isVersioned = node.hasPropertyName(NameConstants.JCR_VERSIONHISTORY);
        NodeId vhid = null;
        try {
            InternalVersionHistory vh;
            String intro;
            block13: {
                String type = isVersioned ? "in-use" : "candidate";
                log.debug("Checking " + type + " version history of node {}", (Object)nid);
                intro = "Removing references to an inconsistent " + type + " version history of node " + nid;
                message = intro + " (getting the VersionInfo)";
                VersionHistoryInfo vhi = this.versionManager.getVersionHistoryInfoForNode(node);
                if (vhi != null) {
                    vhid = vhi.getVersionHistoryId();
                }
                message = intro + " (getting the InternalVersionHistory)";
                vh = null;
                try {
                    vh = this.versionManager.getVersionHistoryOfNode(nid);
                }
                catch (ItemNotFoundException ex) {
                    if (!isVersioned) break block13;
                    throw ex;
                }
            }
            if (vh == null) {
                if (isVersioned) {
                    message = intro + "getVersionHistoryOfNode returned null";
                    throw new InconsistentVersioningState(message);
                }
            } else {
                vhid = vh.getId();
                message = intro + " (getting the version names failed)";
                Name[] versionNames = vh.getVersionNames();
                boolean seenRoot = false;
                for (Name versionName : versionNames) {
                    seenRoot |= NameConstants.JCR_ROOTVERSION.equals(versionName);
                    log.debug("Checking version history of node {}, version {}", (Object)nid, (Object)versionName);
                    message = intro + " (getting version " + versionName + "  failed)";
                    InternalVersion v = vh.getVersion(versionName);
                    message = intro + "(frozen node of root version " + v.getId() + " missing)";
                    if (null != v.getFrozenNode()) continue;
                    throw new InconsistentVersioningState(message);
                }
                if (!seenRoot) {
                    message = intro + " (root version is missing)";
                    throw new InconsistentVersioningState(message);
                }
            }
        }
        catch (InconsistentVersioningState e) {
            log.info(message, (Throwable)e);
            NodeId nvhid = e.getVersionHistoryNodeId();
            if (nvhid != null) {
                if (vhid != null && !nvhid.equals(vhid)) {
                    log.error("vhrid returned with InconsistentVersioningState does not match the id we already had: " + vhid + " vs " + nvhid);
                }
                vhid = nvhid;
            }
            this.removeVersionHistoryReferences(node, vhid);
        }
        catch (Exception e) {
            log.info(message, (Throwable)e);
            this.removeVersionHistoryReferences(node, vhid);
        }
    }

    private void removeVersionHistoryReferences(NodeState node, NodeId vhid) {
        NodeState modified = new NodeState(node, 2, true);
        HashSet<Name> mixins = new HashSet<Name>(node.getMixinTypeNames());
        if (mixins.remove(NameConstants.MIX_VERSIONABLE)) {
            modified.setMixinTypeNames(mixins);
        }
        this.removeProperty(modified, NameConstants.JCR_VERSIONHISTORY);
        this.removeProperty(modified, NameConstants.JCR_BASEVERSION);
        this.removeProperty(modified, NameConstants.JCR_PREDECESSORS);
        this.removeProperty(modified, NameConstants.JCR_ISCHECKEDOUT);
        this.workspaceChanges.modified(modified);
        if (vhid != null) {
            log.info("trying to rename version history of node " + node.getId());
            NameFactory nf = NameFactoryImpl.getInstance();
            Name vhrname = nf.create("", node.getId().toString());
            try {
                NodeState vhrState = this.versionManager.getPersistenceManager().load(vhid);
                NodeState vhrParentState = this.versionManager.getPersistenceManager().load(vhrState.getParentId());
                if (vhrParentState.hasChildNodeEntry(vhrname)) {
                    NodeState modifiedParent = (NodeState)this.vworkspaceChanges.get(vhrState.getParentId());
                    if (modifiedParent == null) {
                        modifiedParent = new NodeState(vhrParentState, 2, true);
                    }
                    Calendar now = Calendar.getInstance();
                    String appendme = " (disconnected by RepositoryChecker on " + ISO8601.format((Calendar)now) + ")";
                    modifiedParent.renameChildNodeEntry(vhid, nf.create(vhrname.getNamespaceURI(), vhrname.getLocalName() + appendme));
                    this.vworkspaceChanges.modified(modifiedParent);
                } else {
                    log.info("child node entry " + vhrname + " for version history not found inside parent folder.");
                }
            }
            catch (Exception ex) {
                log.error("while trying to rename the version history", (Throwable)ex);
            }
        }
    }

    private void removeProperty(NodeState node, Name name) {
        if (node.hasPropertyName(name)) {
            node.removePropertyName(name);
            try {
                this.workspaceChanges.deleted(this.workspace.load(new PropertyId(node.getNodeId(), name)));
            }
            catch (ItemStateException itemStateException) {
                // empty catch block
            }
        }
    }
}

