/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.util.Collection;

public class ReferenceCollectionTypeValidator
implements Validator<Collection<ConfigurationItem>> {
    private PropertyDescriptor propertyDescriptor;

    public ReferenceCollectionTypeValidator(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void validate(Collection<ConfigurationItem> collection, ValidationContext validationContext) {
        Type type = this.propertyDescriptor.getReferencedType();
        for (ConfigurationItem configurationItem : collection) {
            if (type.isSuperTypeOf(configurationItem.getType()) || type.equals(configurationItem.getType())) continue;
            validationContext.error("Cannot set [%s] with ci [%s] as it is not of type [%s]", this.propertyDescriptor.getFqn(), configurationItem.getId(), type);
        }
    }
}

