/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import com.xebialabs.deployit.core.api.dto.RoleAssignments;
import com.xebialabs.deployit.core.api.dto.RolePermission;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.Roles;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
extends AbstractSecuredResource
implements SecurityProxy {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private PermissionLister permissionLister;
    @Autowired
    private DtoWriter dtoWriter;
    @Autowired
    private DtoReader dtoReader;
    private static final Logger logger = LoggerFactory.getLogger(SecurityResource.class);

    public Response logout() {
        return ResponseFactory.ok().build();
    }

    public Response getGrantedPermissions(String string) {
        this.checkPermission(Permission.EDIT_SECURITY);
        if (string.equals("global")) {
            logger.debug("Requested global permissions.");
            string = "";
        }
        Multimap multimap = this.permissionEditor.readPermissions(string);
        List<RolePermission> list = this.dtoWriter.writeRolePermissions((Multimap<Role, Permission>)multimap);
        return ResponseFactory.ok((Object)new RolePermissions(list)).build();
    }

    public Response writeGrantedPermissions(String string, RolePermissions rolePermissions) {
        this.checkPermission(Permission.EDIT_SECURITY);
        if (string.equals("global")) {
            logger.debug("Writing global permissions");
            string = "";
        }
        List list = this.roleService.readRoles();
        Multimap<Role, Permission> multimap = this.dtoReader.readRolePermissions(rolePermissions, list);
        this.permissionEditor.editPermissions(string, multimap);
        return ResponseFactory.ok().build();
    }

    public Response getRoleAssignments() {
        this.checkPermission(Permission.EDIT_SECURITY);
        List list = this.roleService.readRoleAssignments();
        logger.debug("RoleService delivered roles: {}", (Object)list);
        List<RoleAssignment> list2 = this.dtoWriter.writeRoleAssignments(list);
        logger.debug("Going to return the following roles: {}", list2);
        return ResponseFactory.ok((Object)new RoleAssignments(list2)).build();
    }

    public Response writeRoleAssignments(RoleAssignments roleAssignments) {
        this.checkPermission(Permission.EDIT_SECURITY);
        logger.debug("Got the following roles: {}", (Object)roleAssignments);
        List<Role> list = this.dtoReader.readRoleAssignments(roleAssignments);
        logger.debug("Going to write the following role assignments: {}", list);
        this.roleService.writeRoleAssignments(list);
        return ResponseFactory.ok().build();
    }

    public Response getRoles() {
        List list = this.roleService.readRoles();
        return ResponseFactory.ok((Object)new Roles(this.dtoWriter.writeRoles(list))).build();
    }

    public Response hasPermission(String string, String string2) {
        this.checkPermission(Permission.find((String)string), string2);
        return ResponseFactory.ok().build();
    }

    public Response retrievePermissions(String string) {
        Role role = this.roleService.getRoleForRoleName(string);
        Multimap multimap = this.permissionLister.listPermissions(role);
        PrincipalPermissions principalPermissions = new PrincipalPermissions(string, multimap);
        return ResponseFactory.ok((Object)principalPermissions).build();
    }

    public Response retrievePermissionsForCurrentUser() {
        Authentication authentication = Permissions.getAuthentication();
        List list = this.roleService.getRolesFor(authentication);
        Multimap multimap = this.permissionLister.listPermissions(list);
        PrincipalPermissions principalPermissions = new PrincipalPermissions(authentication.getName(), multimap);
        return ResponseFactory.ok((Object)principalPermissions).build();
    }

    private Permission getPermission(String string) {
        Permission permission = Permission.find((String)string);
        if (permission == null) {
            throw new UnknownPermissionException(string);
        }
        return permission;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String string) {
            super("Permission %s does not exist.", new Object[]{string});
        }
    }
}

