/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.util.Set;

@Metadata(virtual=true, description="A script executed on a generic container")
public class ExecutedScript<D extends Deployable>
extends AbstractDeployed<D> {
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the noop operation.")
    private String noopScript;
    @Property(required=false, hidden=true, description="Name of working directory on target host. Default is to create a temporary directory which is deleted when connection is closed.")
    private String remoteWorkingDirectoryPath;
    @Property(required=false, hidden=true, defaultValue="false", description="Retain the specified working directory on target host after completion.")
    private boolean retainRemoteWorkingDirectory = false;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the script.")
    private Set<String> classpathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> templateClasspathResources = Sets.newHashSet();

    protected boolean addStep(DeploymentPlanningContext deploymentPlanningContext, int n, String string, String string2) {
        if (!Strings.nullToEmpty((String)string).trim().isEmpty()) {
            ScriptExecutionStep scriptExecutionStep = new ScriptExecutionStep(n, string, (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getDescription(string2));
            LocalFile localFile = (LocalFile)this.getArtifactIfPresent();
            if (localFile != null) {
                scriptExecutionStep.setArtifact(localFile.getFile());
            }
            if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirectoryPath())) {
                scriptExecutionStep.setRemoteWorkingDirPath(this.getRemoteWorkingDirectoryPath());
                scriptExecutionStep.setRetainRemoteWorkingDirOnCompletion(this.isRetainRemoteWorkingDirectory());
            }
            scriptExecutionStep.setTemplateClasspathResources(Lists.newArrayList(this.getTemplateClasspathResources()));
            scriptExecutionStep.setClasspathResources(Lists.newArrayList(this.getClasspathResources()));
            deploymentPlanningContext.addStep((DeploymentStep)scriptExecutionStep);
            return true;
        }
        return false;
    }

    protected OverthereFile getArtifactIfPresent() {
        if (this.getDeployable() instanceof DeployableArtifact) {
            return ((DeployableArtifact)this.getDeployable()).getFile();
        }
        return null;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ExecutedScript executedScript = (ExecutedScript)delta.getDeployed();
        executedScript._create(deploymentPlanningContext);
    }

    private void _create(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.getCreateOrder(), this.getCreateScript(), this.getCreateVerb());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        boolean bl = this.addStep(deploymentPlanningContext, this.getModifyOrder(), this.getModifyScript(), this.getModifyVerb());
        if (!bl) {
            this.executeDestroy(deploymentPlanningContext, delta);
            this.executeCreate(deploymentPlanningContext, delta);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ExecutedScript executedScript = (ExecutedScript)delta.getPrevious();
        executedScript._destroy(deploymentPlanningContext);
    }

    private void _destroy(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.getDestroyOrder(), this.getDestroyScript(), this.getDestroyVerb());
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.getNoopOrder(), this.getNoopScript(), this.getNoopVerb());
    }

    public String getCreateScript() {
        return this.resolveExpression(this.createScript);
    }

    public void setCreateScript(String string) {
        this.createScript = string;
    }

    public String getModifyScript() {
        return this.resolveExpression(this.modifyScript);
    }

    public void setModifyScript(String string) {
        this.modifyScript = string;
    }

    public String getDestroyScript() {
        return this.resolveExpression(this.destroyScript);
    }

    public void setDestroyScript(String string) {
        this.destroyScript = string;
    }

    public String getNoopScript() {
        return this.resolveExpression(this.noopScript);
    }

    public void setNoopScript(String string) {
        this.noopScript = string;
    }

    public String getRemoteWorkingDirectoryPath() {
        return this.resolveExpression(this.remoteWorkingDirectoryPath);
    }

    public void setRemoteWorkingDirectoryPath(String string) {
        this.remoteWorkingDirectoryPath = string;
    }

    public boolean isRetainRemoteWorkingDirectory() {
        return this.retainRemoteWorkingDirectory;
    }

    public void setRetainRemoteWorkingDirectory(boolean bl) {
        this.retainRemoteWorkingDirectory = bl;
    }

    public Set<String> getClasspathResources() {
        return this.resolveExpression(this.classpathResources);
    }

    public void setClasspathResources(Set<String> set) {
        this.classpathResources = set;
    }

    public Set<String> getTemplateClasspathResources() {
        return this.resolveExpression(this.templateClasspathResources);
    }

    public void setTemplateClasspathResources(Set<String> set) {
        this.templateClasspathResources = set;
    }
}

