/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.OutputStream;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileWriter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.util.StringUtil;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";

    protected PyObject getObject(PySystemState ss) {
        return ss.stdout;
    }

    protected void setObject(PySystemState ss, PyObject obj) {
        ss.stdout = obj;
    }

    protected PyObject myFile() {
        PySystemState ss = Py.getSystemState();
        PyObject obj = this.getObject(ss);
        if (obj == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (obj.getJavaProxy() != null) {
            PyFile f = null;
            Object tojava = obj.__tojava__(OutputStream.class);
            if (tojava != null && tojava != Py.NoConversion) {
                f = new PyFile((OutputStream)tojava);
            }
            if (f != null) {
                this.setObject(ss, f);
                return f;
            }
        }
        return obj;
    }

    public void flush() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            ((PyFile)obj).flush();
        } else {
            try {
                obj.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
    }

    public void write(String s) {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            ((PyFile)obj).write(s);
        } else {
            obj.invoke("write", new PyString(s));
        }
    }

    public void write(int i) {
        this.write(new String(new char[]{(char)i}));
    }

    public void write(byte[] data, int off, int len) {
        this.write(StringUtil.fromBytes(data, off, len));
    }

    public void flushLine() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            if (file.softspace) {
                file.write("\n");
                file.flush();
            }
            file.softspace = false;
        } else {
            PyObject ss = obj.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                obj.invoke("write", Py.Newline);
            }
            try {
                obj.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
            obj.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    public void print(PyObject o, boolean space, boolean newline) {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s = o instanceof PyUnicode && file.encoding != null ? ((PyUnicode)o).encode(file.encoding, "strict") : o.__str__().toString();
            file.write(s);
            if (o instanceof PyString) {
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else if (obj instanceof PyFileWriter) {
            PyFileWriter file = (PyFileWriter)obj;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s = o instanceof PyString ? ((PyString)o).string : o.toString();
            file.write(s);
            if (o instanceof PyString) {
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else {
            PyObject ss = obj.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                obj.invoke("write", Py.Space);
                obj.__setattr__("softspace", (PyObject)Py.Zero);
            }
            if (!(o instanceof PyUnicode)) {
                o = o.__str__();
            }
            obj.invoke("write", o);
            if (o instanceof PyString) {
                String s = o.toString();
                int len = s.length();
                if (len == 0 || !Character.isWhitespace(s.charAt(len - 1)) || s.charAt(len - 1) == ' ') {
                    obj.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
                }
            } else {
                obj.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
            }
            if (newline) {
                obj.invoke("write", Py.Newline);
                obj.__setattr__("softspace", (PyObject)Py.Zero);
            }
        }
    }

    public void print(String s) {
        this.print(new PyString(s), false, false);
    }

    public void println(String s) {
        this.print(new PyString(s), false, true);
    }

    public void print(PyObject o) {
        this.print(o, false, false);
    }

    public void printComma(PyObject o) {
        this.print(o, true, false);
    }

    public void println(PyObject o) {
        this.print(o, false, true);
    }

    public void println() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            file.write("\n");
            file.flush();
            file.softspace = false;
        } else {
            obj.invoke("write", Py.Newline);
            obj.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }
}

