/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingConcurrentModelController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsResourceAccountant;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsResourceController
extends FsDecoratingConcurrentModelController<FsController<? extends FsConcurrentModel>> {
    private static final AccountingSocketFactory ACCOUNTING_SOCKET_FACTORY = JSE7.AVAILABLE ? AccountingSocketFactory.NIO2 : AccountingSocketFactory.OIO;
    @CheckForNull
    private FsResourceAccountant accountant;

    public FsResourceController(FsController<? extends FsConcurrentModel> controller) {
        super(controller);
    }

    private FsResourceAccountant getAccountant() {
        FsResourceAccountant accountant = this.accountant;
        return null != accountant ? accountant : (this.accountant = new FsResourceAccountant(this.writeLock()));
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return ACCOUNTING_SOCKET_FACTORY.newInputSocket(this, this.delegate.getInputSocket(name, options));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return ACCOUNTING_SOCKET_FACTORY.newOutputSocket(this, this.delegate.getOutputSocket(name, options, template));
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (this.isWriteLockedByCurrentThread());
        this.waitOtherThreads(options, handler);
        this.closeAllResources(handler);
        this.delegate.sync(options, handler);
    }

    private <X extends IOException> void waitOtherThreads(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        boolean force;
        FsResourceAccountant accountant = this.accountant;
        if (null == accountant) {
            return;
        }
        boolean wait = options.get(FsSyncOption.WAIT_CLOSE_INPUT) || options.get(FsSyncOption.WAIT_CLOSE_OUTPUT);
        int resources = accountant.waitOtherThreads(wait ? 0L : 50L);
        if (0 >= resources) {
            return;
        }
        OutputBusyException cause = new OutputBusyException("Number of open entry resources: " + resources);
        boolean bl = force = options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
        if (!force) {
            throw (IOException)handler.fail(new FsSyncException((FsModel)this.getModel(), cause));
        }
        handler.warn(new FsSyncWarningException((FsModel)this.getModel(), cause));
    }

    private <X extends IOException> void closeAllResources(final ExceptionHandler<? super FsSyncException, X> handler) throws X {
        FsResourceAccountant accountant = this.accountant;
        if (null != accountant) {
            class FilterExceptionHandler
            implements ExceptionHandler<IOException, X> {
                FilterExceptionHandler() {
                }

                @Override
                public X fail(IOException shouldNotHappen) {
                    throw new AssertionError((Object)shouldNotHappen);
                }

                @Override
                public void warn(IOException cause) throws IOException {
                    handler.warn(new FsSyncWarningException((FsModel)FsResourceController.this.getModel(), cause));
                }
            }
            accountant.closeAllResources(new FilterExceptionHandler());
        }
    }

    private final class AccountedOutputStream
    extends DecoratingOutputStream {
        AccountedOutputStream(OutputStream out) {
            super(out);
            FsResourceController.this.getAccountant().startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            FsResourceController.this.getAccountant().stopAccountingFor(this);
            this.delegate.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.delegate.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private final class AccountedInputStream
    extends DecoratingInputStream {
        AccountedInputStream(InputStream in) {
            super(in);
            FsResourceController.this.getAccountant().startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            FsResourceController.this.getAccountant().stopAccountingFor(this);
            this.delegate.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.delegate.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private final class AccountedSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        AccountedSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
            FsResourceController.this.getAccountant().startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            FsResourceController.this.getAccountant().stopAccountingFor(this);
            this.delegate.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.delegate.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private final class AccountedReadOnlyFile
    extends DecoratingReadOnlyFile {
        AccountedReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
            FsResourceController.this.getAccountant().startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            FsResourceController.this.getAccountant().stopAccountingFor(this);
            this.delegate.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.delegate.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(OutputSocket<?> output) {
            super(output);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            return new AccountedOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    private final class Nio2Output
    extends Output {
        Nio2Output(OutputSocket<?> output) {
            super(output);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            return new AccountedSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(InputSocket<?> input) {
            super(input);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            return new AccountedReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            return new AccountedInputStream(this.getBoundSocket().newInputStream());
        }
    }

    private final class Nio2Input
    extends Input {
        Nio2Input(InputSocket<?> input) {
            super(input);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            assert (FsResourceController.this.isWriteLockedByCurrentThread());
            return new AccountedSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum AccountingSocketFactory {
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, InputSocket<?> input) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, OutputSocket<?> output) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Output(output);
            }
        }
        ,
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, InputSocket<?> input) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, OutputSocket<?> output) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Output(output);
            }
        };


        abstract InputSocket<?> newInputSocket(FsResourceController var1, InputSocket<?> var2);

        abstract OutputSocket<?> newOutputSocket(FsResourceController var1, OutputSocket<?> var2);
    }
}

