/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.boot;

import com.xebialabs.deployit.plugin.api.boot.PluginVersions;
import com.xebialabs.deployit.plugin.api.reflect.DeployableGenerator;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorHierarchyInitializer;
import com.xebialabs.deployit.plugin.api.reflect.GlobalContextInitializer;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticInitializer;
import com.xebialabs.deployit.plugin.api.reflect.TypeInitializer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBooter {
    private static final AtomicBoolean isBooted = new AtomicBoolean(false);
    private static final Logger logger = LoggerFactory.getLogger(PluginBooter.class);

    public static void boot() {
        try {
            PluginBooter.boot(true);
        }
        catch (RuntimeException re) {
            logger.error("Quitting, could not boot plugins: ", (Throwable)re);
            throw re;
        }
    }

    public static void bootWithoutGlobalContext() {
        PluginBooter.boot(false);
    }

    private static synchronized void boot(boolean withGlobalContext) {
        if (!isBooted.getAndSet(true)) {
            TypeInitializer.init();
            SyntheticInitializer.init();
            DescriptorHierarchyInitializer.init();
            DeployableGenerator.init();
            if (withGlobalContext) {
                GlobalContextInitializer.init();
            }
            PluginVersions.init();
        }
    }
}

