/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.ClassUtils;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.ValidationRuleConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Descriptor {
    static final String PLACEHOLDERS_FIELD = "placeholders";
    private Type type;
    private Class<? extends ConfigurationItem> clazz;
    private String description;
    private Metadata.ConfigurationItemRoot root;
    private List<Type> superclasses = Lists.newArrayList();
    private Set<Type> interfaces = Sets.newHashSet();
    private boolean virtual = false;
    private Map<String, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private Type deployableType;
    private Type containerType;
    private Type generatedDeployableType;
    private Type generatedDeployableBase;
    private String generatedDeployableDescription;
    private boolean hierarchyInitialized = false;
    private Map<String, MethodDescriptor> controlTasks = Maps.newHashMap();
    private List<Validator<ConfigurationItem>> validators = Lists.newArrayList();
    private Field syntheticPropertiesField;
    private static final Logger logger = LoggerFactory.getLogger(Descriptor.class);

    private Descriptor(Class<? extends ConfigurationItem> clazz) {
        this.type = Type.valueOf(clazz);
        this.virtual = clazz.isInterface();
        this.clazz = clazz;
    }

    private Descriptor(Type type) {
        this.type = type;
    }

    static Descriptor from(Class<? extends ConfigurationItem> clazz) {
        try {
            Descriptor descriptor = new Descriptor(clazz);
            descriptor.initMetadata();
            descriptor.scanClass();
            return descriptor;
        }
        catch (RuntimeException e) {
            throw new DescriptorException("Could not create descriptor for: " + clazz.getName(), e);
        }
    }

    private void initMetadata() {
        Annotation[] declaredAnnotations;
        if (this.virtual) {
            return;
        }
        boolean directlyAnnotated = false;
        for (Annotation declaredAnnotation : declaredAnnotations = this.clazz.getDeclaredAnnotations()) {
            if (!declaredAnnotation.annotationType().equals(Metadata.class)) continue;
            directlyAnnotated = true;
        }
        Metadata annotation = (Metadata)Preconditions.checkNotNull((Object)this.clazz.getAnnotation(Metadata.class), (Object)("Class " + this.clazz.getName() + " or one of its ancestors does not have a @Metadata annotation"));
        this.description = annotation.description();
        this.root = annotation.root();
        this.virtual = directlyAnnotated && annotation.virtual() || Modifier.isAbstract(this.clazz.getModifiers());
    }

    private void scanClass() {
        this.findProperties();
        this.findControlTasks();
        this.findInterfaces();
        this.findValidations();
        Class<? extends ConfigurationItem> superclass = this.clazz.getSuperclass();
        if (superclass != null && ConfigurationItem.class.isAssignableFrom(superclass)) {
            Type supertype = Type.valueOf(superclass);
            this.addSuperClass(supertype);
        }
        this.initDeployableAndContainerTypes();
    }

    private void findValidations() {
        for (Annotation annotation : this.clazz.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            Validator<?> v = ValidationRuleConverter.makeRule(annotation);
            this.validators.add(v);
        }
    }

    private void findControlTasks() {
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ControlTask.class)) continue;
            MethodDescriptor from = MethodDescriptor.from(this, method);
            this.addControlTask(from);
        }
    }

    private void findProperties() {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            PropertyDescriptor propertyDescriptor = PropertyDescriptor.from(this, field);
            this.addProperty(propertyDescriptor);
        }
    }

    private void findInterfaces() {
        Class<?>[] clazzInterfaces = this.clazz.getInterfaces();
        ArrayList allInterfacesFound = Lists.newArrayList();
        this.findAllSuperInterfaces(clazzInterfaces, allInterfacesFound);
        for (Class clazzInterface : allInterfacesFound) {
            if (!clazzInterface.getPackage().isAnnotationPresent(Prefix.class)) continue;
            this.addInterface(Type.valueOf(clazzInterface));
        }
    }

    private void findAllSuperInterfaces(Class<?>[] childInterfaces, List<Class<?>> allInterfacesFound) {
        for (Class<?> childInterface : childInterfaces) {
            allInterfacesFound.add(childInterface);
            this.findAllSuperInterfaces(childInterface.getInterfaces(), allInterfacesFound);
        }
    }

    private void initDeployableAndContainerTypes() {
        if (Deployed.class.isAssignableFrom(this.clazz)) {
            List<Class<?>> typeArguments = ClassUtils.getActualTypeArguments(this.clazz, Deployed.class);
            Preconditions.checkArgument((typeArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly a Deployable and a Container, but got %s", (Object[])new Object[]{typeArguments});
            Class<?> deployableClass = typeArguments.get(0);
            if (deployableClass != null) {
                Preconditions.checkArgument((boolean)Deployable.class.isAssignableFrom(deployableClass), (Object)"Expected first item to be a deployable");
                this.deployableType = Type.valueOf(deployableClass);
            } else {
                this.deployableType = null;
            }
            Class<?> containerClass = typeArguments.get(1);
            if (containerClass != null) {
                Preconditions.checkArgument((boolean)Container.class.isAssignableFrom(containerClass), (Object)"Expected second item to be a container");
                this.containerType = Type.valueOf(containerClass);
            } else {
                this.containerType = null;
            }
        } else {
            this.deployableType = null;
            this.containerType = null;
        }
    }

    static Descriptor from(Element typeElement) {
        Type type = SyntheticHelper.getRequiredTypeAttribute(typeElement, "type");
        Descriptor descriptor = new Descriptor(type);
        descriptor.initSynthetic(typeElement);
        return descriptor;
    }

    private void initSynthetic(Element typeElement) {
        this.description = SyntheticHelper.getOptionalStringAttribute(typeElement, "description", "Description unavailable");
        this.virtual = SyntheticHelper.getOptionalBooleanAttribute(typeElement, "virtual", false);
        Type superType = SyntheticHelper.getRequiredTypeAttribute(typeElement, "extends");
        this.addSuperClass(superType);
        this.parseSyntheticDeployableAndContainerType(typeElement);
        this.parseTypeModification(typeElement);
        this.parseValidators(typeElement);
    }

    private void parseValidators(Element typeElement) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"rule")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                Descriptor.this.validators.add(ValidationRuleConverter.makeRule(element, Descriptor.this.type));
            }
        });
    }

    private void parseSyntheticDeployableAndContainerType(Element typeElement) {
        this.deployableType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "deployable-type");
        this.containerType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "container-type");
        Iterator<Element> generateElements = SyntheticHelper.childByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            this.generatedDeployableType = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "type");
            this.generatedDeployableBase = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "extends");
            this.generatedDeployableDescription = SyntheticHelper.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable");
        }
    }

    void parseTypeModification(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"property")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                String name = SyntheticHelper.getRequiredStringAttribute(element, "name");
                PropertyDescriptor newDesc = PropertyDescriptor.from(Descriptor.this, element);
                PropertyDescriptor oldDesc = (PropertyDescriptor)Descriptor.this.properties.get(name);
                if (oldDesc != null) {
                    newDesc.overrideWith(oldDesc);
                }
                Descriptor.this.addProperty(newDesc);
            }
        });
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"method")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                MethodDescriptor controlTask = MethodDescriptor.from(Descriptor.this, element);
                Descriptor.this.verifyNewControlTask(controlTask);
                Descriptor.this.addControlTask(controlTask);
            }
        });
    }

    private void verifyNewControlTask(MethodDescriptor controlTask) {
        if (this.controlTasks.containsKey(controlTask.getName())) {
            throw new IllegalStateException("Cannot override existing Control Task [" + controlTask.getName() + "] with a synthetic one.");
        }
    }

    static Descriptor from(Descriptor deployedDescriptor) {
        Descriptor deployableDescriptor = new Descriptor(deployedDescriptor.generatedDeployableType);
        deployableDescriptor.addSuperClass(deployedDescriptor.generatedDeployableBase);
        deployableDescriptor.initDeployableFromDeployed(deployedDescriptor, deployedDescriptor.generatedDeployableDescription);
        return deployableDescriptor;
    }

    private void initDeployableFromDeployed(Descriptor deployedDescriptor, String generatedDeployableDescription) {
        this.description = generatedDeployableDescription == null || generatedDeployableDescription.equals("Description unavailable") ? deployedDescriptor.getDescription() + " (deployable)" : generatedDeployableDescription;
        for (PropertyDescriptor pd : deployedDescriptor.getPropertyDescriptors()) {
            boolean isReferenceField;
            String name = pd.getName();
            boolean isUdmField = name.equals("deployable") || name.equals("container") || name.equals(PLACEHOLDERS_FIELD);
            PropertyKind kind = pd.getKind();
            boolean bl = isReferenceField = kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
            if (isUdmField || isReferenceField || pd.isHidden()) continue;
            this.addProperty(PropertyDescriptor.generateDeployableFrom(this, pd));
        }
    }

    void initHierarchy() {
        if (this.hierarchyInitialized || this.superclasses.isEmpty()) {
            return;
        }
        Type toInitFrom = this.superclasses.get(0);
        do {
            Descriptor superDesc;
            if ((superDesc = DescriptorRegistry.getDescriptor(toInitFrom)) == null) {
                throw new IllegalStateException("Cannot build type hierarchy for " + this.getType() + " because one of its supertypes cannot be found: " + toInitFrom + " not found");
            }
            if (this.root == null) {
                this.root = superDesc.getRoot();
            }
            if (this.clazz == null) {
                this.clazz = superDesc.clazz;
            }
            this.inheritPropertyDescriptors(this.properties, superDesc.properties);
            this.inheritControlTasks(this.controlTasks, superDesc.controlTasks);
            this.inheritValidators(this.validators, superDesc.validators);
            for (Type superclass : superDesc.superclasses) {
                this.addSuperClass(superclass);
            }
            for (Type intf : superDesc.interfaces) {
                this.addInterface(intf);
            }
            Type type = toInitFrom = superDesc.superclasses.isEmpty() || superDesc.hierarchyInitialized ? null : superDesc.getSuperClasses().get(0);
            if (this.deployableType == null) {
                this.deployableType = superDesc.getDeployableType();
            }
            if (this.containerType != null) continue;
            this.containerType = superDesc.getContainerType();
        } while (toInitFrom != null);
        this.syntheticPropertiesField = ReflectionUtils.searchField(this.clazz, "syntheticProperties");
        this.syntheticPropertiesField.setAccessible(true);
        this.verify();
        this.hierarchyInitialized = true;
    }

    private void verify() {
        this.verifySyntheticPropertiesField();
        this.verifyReferenceTypes();
        this.verifyNonArtifactDoesNotHavePlaceholders();
        this.verifyArtifactInterfaces();
        if (!this.isVirtual()) {
            this.verifyJavaClassIsNotAbstract();
            this.verifyDeployedHasDeployableAndContainerType();
            this.verifyHiddenRequiredPropertiesHaveDefaultValue();
            this.verifyControlTasks();
        }
    }

    private void verifySyntheticPropertiesField() {
        Preconditions.checkNotNull((Object)this.syntheticPropertiesField, (Object)"Synthetic properties field should be set");
        Preconditions.checkState((boolean)this.syntheticPropertiesField.getType().isAssignableFrom(Map.class), (String)"Synthetic properties field should be Map<String, Object>, not: %s", (Object[])new Object[]{this.syntheticPropertiesField.getType()});
    }

    private void verifyControlTasks() {
        for (MethodDescriptor controlTask : this.controlTasks.values()) {
            controlTask.verify();
        }
    }

    private void verifyReferenceTypes() {
        for (PropertyDescriptor p : this.properties.values()) {
            PropertyKind kind = p.getKind();
            if (kind != PropertyKind.CI && kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
            Preconditions.checkState((boolean)this.isValidReferencedType(p.getReferencedType()), (String)"Property %s of type %s refers to non-existing type %s", (Object[])new Object[]{p.getName(), p.getDeclaringDescriptor().getType(), p.getReferencedType()});
        }
    }

    private boolean isValidReferencedType(Type referencedType) {
        if (DescriptorRegistry.exists(referencedType)) {
            return true;
        }
        for (Descriptor d : DescriptorRegistry.getDescriptors()) {
            if (d.getSuperClasses().contains(referencedType)) {
                return true;
            }
            if (!d.getInterfaces().contains(referencedType)) continue;
            return true;
        }
        return false;
    }

    private void verifyNonArtifactDoesNotHavePlaceholders() {
        if (!this.isAssignableTo(Artifact.class)) {
            for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
                Preconditions.checkState((!propertyDescriptor.getName().equals(PLACEHOLDERS_FIELD) ? 1 : 0) != 0, (String)"Type %s that does not implemnt the udm.Artifact interface must not have a field called 'placeholders'", (Object[])new Object[]{this.type});
            }
        }
    }

    private void verifyArtifactInterfaces() {
        if (this.isAssignableTo(Deployable.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(SourceArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.SourceArtifact interface", (Object[])new Object[]{this.type});
            Preconditions.checkState((boolean)this.isAssignableTo(DeployableArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.DeployableArtifact interface", (Object[])new Object[]{this.type});
        }
        if (this.isAssignableTo(Deployed.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(DerivedArtifact.class), (String)"Type %s that implements the udm.Deployed and udm.Artifact interface must also implement the udm.DerivedArtifact interface", (Object[])new Object[]{this.type});
        }
    }

    private void verifyJavaClassIsNotAbstract() {
        Preconditions.checkState((!Modifier.isAbstract(this.clazz.getModifiers()) ? 1 : 0) != 0, (String)"Non-virtual type %s has an abstract Java class %s", (Object[])new Object[]{this.getType(), this.clazz.getName()});
    }

    private void verifyDeployedHasDeployableAndContainerType() {
        Type deployedType = Type.valueOf(Deployed.class);
        if (this.isAssignableTo(deployedType)) {
            Preconditions.checkState((this.getDeployableType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a deployable-type", (Object[])new Object[]{this.getType(), deployedType});
            Preconditions.checkState((this.getContainerType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a container-type", (Object[])new Object[]{this.getType(), deployedType});
        }
    }

    private void verifyHiddenRequiredPropertiesHaveDefaultValue() {
        for (PropertyDescriptor p : this.properties.values()) {
            if (!p.isHidden() || !p.isRequired()) continue;
            Preconditions.checkState((p.getDefaultValue() != null ? 1 : 0) != 0, (String)"Hidden required property %s of non-virtual type %s must have a default value", (Object[])new Object[]{p.getName(), this.getType()});
        }
    }

    private void inheritValidators(List<Validator<ConfigurationItem>> dest, List<Validator<ConfigurationItem>> source) {
        dest.addAll(source);
    }

    private void inheritControlTasks(Map<String, MethodDescriptor> dest, Map<String, MethodDescriptor> source) {
        for (Map.Entry<String, MethodDescriptor> sourceEntry : source.entrySet()) {
            if (!dest.containsKey(sourceEntry.getKey())) {
                dest.put(sourceEntry.getKey(), new MethodDescriptor(sourceEntry.getValue(), this));
                continue;
            }
            logger.warn("Not inheriting ControlTask [{}] on [{}]", new Object[]{sourceEntry.getValue().getFqn(), this.type});
        }
    }

    private void inheritPropertyDescriptors(Map<String, PropertyDescriptor> dest, Map<String, PropertyDescriptor> source) {
        LinkedHashMap myDescriptors = Maps.newLinkedHashMap(dest);
        dest.clear();
        for (Map.Entry<String, PropertyDescriptor> sourceEntry : source.entrySet()) {
            if (!myDescriptors.containsKey(sourceEntry.getKey())) {
                dest.put(sourceEntry.getKey(), new PropertyDescriptor(sourceEntry.getValue(), this));
                continue;
            }
            ((PropertyDescriptor)myDescriptors.get(sourceEntry.getKey())).overrideWith(sourceEntry.getValue());
        }
        dest.putAll(myDescriptors);
    }

    private void addSuperClass(Type supertype) {
        this.superclasses.add(supertype);
        DescriptorRegistry.registerSubtype(supertype, this.type);
    }

    private void addInterface(Type intf) {
        DescriptorRegistry.registerSubtype(intf, this.type);
        this.interfaces.add(intf);
    }

    private void addProperty(PropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    private void addControlTask(MethodDescriptor from) {
        this.controlTasks.put(from.getName(), from);
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.properties.values();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.properties.get(name);
    }

    public MethodDescriptor getControlTask(String name) {
        return this.controlTasks.get(name);
    }

    public Collection<MethodDescriptor> getControlTasks() {
        return this.controlTasks.values();
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(Type.valueOf(clazz));
    }

    public boolean isAssignableTo(Type type) {
        return this.type.isSubTypeOf(type) || this.type.equals(type);
    }

    public List<Type> getSuperClasses() {
        return this.superclasses;
    }

    public Set<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        if (item == null) {
            return other == null;
        }
        if (!this.getType().equals(item.getType()) || !this.getType().equals(other.getType())) {
            return false;
        }
        if (!itemsBeingCompared.add(item.getId())) {
            return true;
        }
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            if (pd.areEqual(item, other, itemsBeingCompared)) continue;
            return false;
        }
        return true;
    }

    boolean shouldGenerateDeployableType() {
        return this.generatedDeployableType != null;
    }

    public <T extends ConfigurationItem> T newInstance() {
        if (this.virtual) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.type + " because it is virtual");
        }
        try {
            Field typeField = ReflectionUtils.searchField(this.clazz, "type");
            typeField.setAccessible(true);
            ConfigurationItem t = this.clazz.newInstance();
            typeField.set(t, this.type);
            this.prefillDefaultProperties(t);
            return (T)t;
        }
        catch (InstantiationException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
    }

    private <T extends ConfigurationItem> void prefillDefaultProperties(T t) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            if (pd.getDefaultValue() != null) {
                pd.set(t, pd.getDefaultValue());
                continue;
            }
            pd.set(t, pd.emptyValue());
        }
    }

    public String toString() {
        return "Descriptor[" + this.type + "]";
    }

    public Type getDeployableType() {
        return this.deployableType;
    }

    public Type getContainerType() {
        return this.containerType;
    }

    Field getSyntheticPropertiesField() {
        return this.syntheticPropertiesField;
    }

    public List<ValidationMessage> validate(final ConfigurationItem ci) {
        final ArrayList messages = Lists.newArrayList();
        for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
            propertyDescriptor.validate(ci, messages);
        }
        for (Validator validator : this.validators) {
            validator.validate(ci, new ValidationContext(){

                @Override
                public void error(String message, Object ... params) {
                    messages.add(new ValidationMessage(ci.getId(), null, String.format(message, params)));
                }
            });
        }
        return messages;
    }

    private static class DescriptorException
    extends RuntimeException {
        public DescriptorException(String s, RuntimeException e) {
            super(s, e);
        }
    }
}

