/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.ChannelInputStream;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import net.schmizz.sshj.connection.channel.direct.PTYMode;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.transport.TransportException;

public class SessionChannel
extends AbstractDirectChannel
implements Session,
Session.Command,
Session.Shell,
Session.Subsystem {
    private final ChannelInputStream err;
    private Integer exitStatus;
    private Signal exitSignal;
    private Boolean wasCoreDumped;
    private String exitErrMsg;
    private Boolean canDoFlowControl;
    private boolean usedUp;

    public SessionChannel(Connection conn) {
        super(conn, "session");
        this.err = new ChannelInputStream(this, this.trans, this.lwin);
    }

    @Override
    public void allocateDefaultPTY() throws ConnectionException, TransportException {
        this.allocatePTY("dummy", 80, 24, 0, 0, Collections.<PTYMode, Integer>emptyMap());
    }

    @Override
    public void allocatePTY(String term, int cols, int rows, int width, int height, Map<PTYMode, Integer> modes) throws ConnectionException, TransportException {
        this.sendChannelRequest("pty-req", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(term)).putUInt32(cols)).putUInt32(rows)).putUInt32(width)).putUInt32(height)).putBytes(PTYMode.encode(modes))).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public Boolean canDoFlowControl() {
        return this.canDoFlowControl;
    }

    @Override
    public void changeWindowDimensions(int cols, int rows, int width, int height) throws TransportException {
        this.sendChannelRequest("window-change", false, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putUInt32(cols)).putUInt32(rows)).putUInt32(width)).putUInt32(height));
    }

    @Override
    public Session.Command exec(String command) throws ConnectionException, TransportException {
        this.checkReuse();
        this.log.info("Will request to exec `{}`", (Object)command);
        this.sendChannelRequest("exec", true, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(command)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        this.usedUp = true;
        return this;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public String getExitErrorMessage() {
        return this.exitErrMsg;
    }

    @Override
    public Signal getExitSignal() {
        return this.exitSignal;
    }

    @Override
    public Integer getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public void handleRequest(String req, SSHPacket buf) throws ConnectionException, TransportException {
        try {
            if ("xon-xoff".equals(req)) {
                this.canDoFlowControl = buf.readBoolean();
            } else if ("exit-status".equals(req)) {
                this.exitStatus = buf.readUInt32AsInt();
            } else if ("exit-signal".equals(req)) {
                this.exitSignal = Signal.fromString(buf.readString());
                this.wasCoreDumped = buf.readBoolean();
                this.exitErrMsg = buf.readString();
                this.sendClose();
            } else {
                super.handleRequest(req, buf);
            }
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
    }

    @Override
    public void reqX11Forwarding(String authProto, String authCookie, int screen) throws ConnectionException, TransportException {
        this.sendChannelRequest("x11-req", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putBoolean(false)).putString(authProto)).putString(authCookie)).putUInt32(screen)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void setEnvVar(String name, String value) throws ConnectionException, TransportException {
        this.sendChannelRequest("env", true, (Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(name)).putString(value)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void signal(Signal sig) throws TransportException {
        this.sendChannelRequest("signal", false, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(sig.toString()));
    }

    @Override
    public Session.Shell startShell() throws ConnectionException, TransportException {
        this.checkReuse();
        this.sendChannelRequest("shell", true, null).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        this.usedUp = true;
        return this;
    }

    @Override
    public Session.Subsystem startSubsystem(String name) throws ConnectionException, TransportException {
        this.checkReuse();
        this.log.info("Will request `{}` subsystem", (Object)name);
        this.sendChannelRequest("subsystem", true, (Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(name)).await(this.conn.getTimeout(), TimeUnit.SECONDS);
        this.usedUp = true;
        return this;
    }

    @Override
    public Boolean getExitWasCoreDumped() {
        return this.wasCoreDumped;
    }

    @Override
    protected void closeAllStreams() {
        IOUtils.closeQuietly(this.err);
        super.closeAllStreams();
    }

    @Override
    protected void eofInputStreams() {
        this.err.eof();
        super.eofInputStreams();
    }

    @Override
    protected void gotExtendedData(SSHPacket buf) throws ConnectionException, TransportException {
        try {
            int dataTypeCode = buf.readUInt32AsInt();
            if (dataTypeCode != 1) {
                throw new ConnectionException(DisconnectReason.PROTOCOL_ERROR, "Bad extended data type = " + dataTypeCode);
            }
            this.receiveInto(this.err, buf);
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
    }

    @Override
    public void notifyError(SSHException error) {
        this.err.notifyError(error);
        super.notifyError(error);
    }

    private void checkReuse() {
        if (this.usedUp) {
            throw new SSHRuntimeException("This session channel is all used up");
        }
    }
}

