/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;

public class AuthKeyboardInteractive
extends AbstractAuthMethod {
    private final ChallengeResponseProvider provider;

    public AuthKeyboardInteractive(ChallengeResponseProvider provider) {
        super("keyboard-interactive");
        this.provider = provider;
    }

    @Override
    public SSHPacket buildReq() throws UserAuthException {
        return (SSHPacket)((SSHPacket)super.buildReq().putString("")).putString(this.buildCommaSeparatedSubmethodList());
    }

    private String buildCommaSeparatedSubmethodList() {
        StringBuilder sb = new StringBuilder();
        for (String submethod : this.provider.getSubmethods()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(submethod);
        }
        return sb.toString();
    }

    @Override
    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd != Message.USERAUTH_60) {
            super.handle(cmd, buf);
        } else {
            CharArrWrap[] userReplies;
            try {
                this.provider.init(this.makeAccountResource(), buf.readString(), buf.readString());
                buf.readString();
                int numPrompts = buf.readUInt32AsInt();
                userReplies = new CharArrWrap[numPrompts];
                for (int i = 0; i < numPrompts; ++i) {
                    String prompt = buf.readString();
                    boolean echo = buf.readBoolean();
                    this.log.info("Requesting response for challenge `{}`; echo={}", (Object)prompt, (Object)echo);
                    userReplies[i] = new CharArrWrap(this.provider.getResponse(prompt, echo));
                }
            }
            catch (Buffer.BufferException be) {
                throw new UserAuthException(be);
            }
            this.respond(userReplies);
        }
    }

    private void respond(CharArrWrap[] userReplies) throws TransportException {
        SSHPacket pkt = (SSHPacket)new SSHPacket(Message.USERAUTH_INFO_RESPONSE).putUInt32(userReplies.length);
        for (CharArrWrap response : userReplies) {
            pkt.putSensitiveString(response.arr);
        }
        this.params.getTransport().write(pkt);
    }

    @Override
    public boolean shouldRetry() {
        return this.provider.shouldRetry();
    }

    private static class CharArrWrap {
        private final char[] arr;

        private CharArrWrap(char[] arr) {
            this.arr = arr;
        }
    }
}

