/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FileInputSocket
extends InputSocket<FileEntry> {
    private final FileEntry entry;

    FileInputSocket(FileEntry entry) {
        assert (null != entry);
        this.entry = entry;
    }

    public FileEntry getLocalTarget() {
        return this.entry;
    }

    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        return Files.newByteChannel(this.entry.getPath(), new OpenOption[0]);
    }

    public ReadOnlyFile newReadOnlyFile() throws IOException {
        return new DefaultReadOnlyFile(this.entry.getPath().toFile());
    }

    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.entry.getPath(), new OpenOption[0]);
    }
}

