/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ControlTaskProxy;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.controltask.ControlTask;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ControlTaskResource
extends AbstractSecuredResource
implements ControlTaskProxy {
    @Autowired
    private DtoWriter dtoWriter;
    @Autowired
    private RepositoryService repository;
    @Autowired
    private ControlTaskService controlTaskService;

    public Response execute(@PathParam(value="task") String controlTask, @PathParam(value="id") String configurationItemId) {
        this.checkPermission(Permission.CONTROLTASK_EXECUTE);
        ConfigurationItem read = this.repository.read(configurationItemId);
        ControlTask task = this.controlTaskService.execute(read, controlTask);
        if (task.getState() == Task.State.STOPPED || task.getState() == Task.State.CANCELLED) {
            task.cancel();
            return ResponseFactory.badRequest((Object)this.dtoWriter.fullTaskToDto((Task)task)).build();
        }
        return ResponseFactory.ok((Object)this.dtoWriter.fullTaskToDto((Task)task)).build();
    }
}

