/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskRegistry;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.Calendar;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskResource
extends AbstractSecuredResource
implements TaskProxy {
    @Autowired
    private DtoWriter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private TaskRegistry taskRegistry;
    @Autowired
    private TaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);

    public Response start(String taskId) {
        this.engine.execute(taskId);
        return ResponseFactory.accepted().build();
    }

    public Response cancel(String taskId) {
        this.engine.cancel(taskId);
        return ResponseFactory.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String taskId) {
        try {
            this.engine.stopExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not stop task %s", taskId), (Throwable)ise);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response abort(String taskId) {
        try {
            this.engine.abortExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not abort task %s", taskId), (Throwable)ise);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response getTaskInfo(String taskId) {
        Task runningTask = this.taskRegistry.getTask(taskId);
        TaskInfo taskInfoDto = runningTask != null ? this.dtoConverter.taskToDto(runningTask) : this.dtoConverter.archivedTaskToDto(this.taskArchive.getTask(taskId));
        return ResponseFactory.ok((Object)taskInfoDto).build();
    }

    public Response assignTask(@PathParam(value="taskid") String taskId, @PathParam(value="owner") String owner) {
        Task task = this.taskRegistry.getTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        if (this.hasPermission(Permission.ADMIN)) {
            this.taskRegistry.assignTask(taskId, owner);
        } else if (this.hasPermission(Permission.TASK_ASSIGN)) {
            this.taskRegistry.assignMyTask(taskId, owner);
        } else {
            throw PermissionDeniedException.withMessage((String)"Neither ADMIN nor TASK_ASSIGN permissions are granted to you or you are not the owner of the task");
        }
        return ResponseFactory.ok().build();
    }

    public Response toggleSkipSteps(@PathParam(value="taskid") String taskId, @PathParam(value="steps") String stepIds) {
        Task task = this.taskRegistry.getTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        if (!this.checkPermission(Permission.TASK_SKIPSTEP, task)) {
            throw new Checks.IncorrectArgumentException("Can only skip steps on a deployment task", new Object[0]);
        }
        Iterable taskStepIds = Splitter.on((String)",").split((CharSequence)stepIds);
        for (String stepId : taskStepIds) {
            int id = Integer.parseInt(stepId);
            TaskStep taskStep = task.getStep(id);
            if (taskStep.canSkip()) {
                logger.info("Skipping step :{}", (Object)taskStep.getDescription());
                taskStep.skip();
                continue;
            }
            if (!taskStep.isSkipped()) continue;
            taskStep.unskip();
        }
        return ResponseFactory.ok((Object)this.dtoConverter.fullTaskToDto(task)).build();
    }

    private boolean checkPermission(Permission permission, Task task) {
        if (task instanceof DeploymentTask) {
            String env = ((DeploymentTask)task).getEnvironment();
            this.checkPermission(permission, env);
            return true;
        }
        return false;
    }

    public Response moveStep(@PathParam(value="taskid") String taskId, @PathParam(value="stepNr") int stepNr, @PathParam(value="position") int newPosition) {
        Task task = this.taskRegistry.getTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        if (!this.checkPermission(Permission.TASK_MOVESTEP, task)) {
            throw new Checks.IncorrectArgumentException("Can only move steps on a deployment task", new Object[0]);
        }
        task.moveStep(stepNr, newPosition);
        return ResponseFactory.ok((Object)this.dtoConverter.fullTaskToDto(task)).build();
    }

    public Response getStepInfo(String taskId, int stepNr, Date ifModifiedSince) {
        TaskStep step;
        Task runningTask = this.taskRegistry.getTask(taskId);
        if (runningTask != null) {
            step = runningTask.getStep(stepNr);
        } else {
            DeploymentTaskInfo archivedTask = this.taskArchive.getTask(taskId);
            step = archivedTask.getStep(stepNr);
        }
        if (this.hasBeenModifiedSince((TaskStepInfo)step, ifModifiedSince)) {
            return ResponseFactory.ok((Object)this.dtoConverter.taskStepInfoToDto(stepNr, (TaskStepInfo)step)).lastModified(step.getLastModificationDate().getTime()).build();
        }
        return ResponseFactory.notModified().build();
    }

    protected boolean hasBeenModifiedSince(TaskStepInfo step, Date ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        Calendar lastModifiedCal = step.getLastModificationDate();
        lastModifiedCal.set(14, 0);
        return ifModifiedSince.getCalendar().before(lastModifiedCal);
    }

    public Response getUnfinishedTasks() {
        return ResponseFactory.ok((Object)this.dtoConverter.tasksToDto(this.engine.getAllIncompleteTasksForCurrentUser())).build();
    }

    public Response getAllUnfinishedTasks() {
        this.checkPermission(Permission.ADMIN);
        return ResponseFactory.ok((Object)this.dtoConverter.tasksToDto(this.engine.getAllIncompleteTasks())).build();
    }

    public Response getStepsForTask(String taskId) {
        Task runningTask = this.taskRegistry.getTask(taskId);
        FullTaskInfo steps = runningTask != null ? this.dtoConverter.fullTaskToDto(runningTask) : this.dtoConverter.fullArchivedTaskToDto(this.taskArchive.getTask(taskId));
        return ResponseFactory.ok((Object)steps).build();
    }
}

