/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.api.dto.Report;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
@Produces(value={"text/csv"})
public class CsvMessageProvider
implements MessageBodyWriter<Object> {
    private static final String CSV_SEPERATOR = ",";
    private static final String LINE_SEPERATOR = "\n";
    private static Logger logger = LoggerFactory.getLogger(CsvMessageProvider.class);

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(Report.class) && mediaType.getType().equals("text") && mediaType.getSubtype().equals("csv");
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.debug("Entering CsvMessageProvider...");
        String csvFormat = this.convertReportToCsvFormat((Report)t);
        entityStream.write(csvFormat.getBytes());
    }

    private String convertReportToCsvFormat(Report report) {
        StringBuilder data = new StringBuilder();
        List reportLines = report.getLines();
        if (reportLines.size() > 0) {
            this.appendReportHeader(data, reportLines);
            this.appendReportRows(data, reportLines);
        }
        return data.toString();
    }

    private void appendReportHeader(StringBuilder data, List<Report.ReportLine> reportLines) {
        Report.ReportLine firstReportLine = reportLines.iterator().next();
        if (firstReportLine != null) {
            Iterator iterator;
            Map map = firstReportLine.getValues();
            Iterator keyIterator = iterator = new TreeSet(map.keySet()).iterator();
            while (keyIterator.hasNext()) {
                String eachHeaderKey = (String)keyIterator.next();
                data.append(this.encloseInQuotes(eachHeaderKey));
                if (!keyIterator.hasNext()) continue;
                data.append(CSV_SEPERATOR);
            }
            data.append(LINE_SEPERATOR);
        }
    }

    private String encloseInQuotes(String eachKey) {
        return "\"" + eachKey + "\"";
    }

    private void appendReportRows(StringBuilder data, List<Report.ReportLine> reportLines) {
        Iterator<Report.ReportLine> rowIter = reportLines.iterator();
        while (rowIter.hasNext()) {
            Report.ReportLine reportLine = rowIter.next();
            this.appendReportRow(data, reportLine);
            if (!rowIter.hasNext()) continue;
            data.append(LINE_SEPERATOR);
        }
    }

    private void appendReportRow(StringBuilder data, Report.ReportLine reportLine) {
        TreeMap values = new TreeMap(reportLine.getValues());
        Iterator columnIter = values.entrySet().iterator();
        while (columnIter.hasNext()) {
            Map.Entry entry = columnIter.next();
            data.append(this.encloseInQuotes(entry.getValue().toString()));
            if (!columnIter.hasNext()) continue;
            data.append(CSV_SEPERATOR);
        }
    }
}

