/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DefaultDelta;
import com.xebialabs.deployit.deployment.planner.DefaultDeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.List;

public class DeltaSpecificationBuilder {
    private Operation operation = Operation.CREATE;
    private List<Delta> deltas = Lists.newArrayList();
    private DeployedApplication deployedApplication;

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder();
    }

    public DeltaSpecificationBuilder create(Deployed d) {
        return this.with(Operation.CREATE, null, d);
    }

    public DeltaSpecificationBuilder modify(Deployed previous, Deployed d) {
        return this.with(Operation.MODIFY, previous, d);
    }

    public DeltaSpecificationBuilder destroy(Deployed d) {
        return this.with(Operation.DESTROY, d, null);
    }

    public DeltaSpecificationBuilder noOp(Deployed d) {
        return this.with(Operation.NOOP, d, d);
    }

    private DeltaSpecificationBuilder with(Operation operation, Deployed previous, Deployed deployed) {
        this.deltas.add(new DefaultDelta(operation, previous, deployed));
        return this;
    }

    public DeltaSpecificationBuilder upgrade(DeployedApplication deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(DeployedApplication deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(DeployedApplication deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public DeltaSpecification build() {
        return new DefaultDeltaSpecification(this.operation, this.deployedApplication, this.deltas);
    }
}

