/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InspectionContext
implements InspectionExecutionContext,
InspectionPlanningContext,
DeploymentExecutionContext {
    private ExecutionContext context;
    private Map<String, Object> attributes;
    private Logger stepLogger;
    private List<Step> steps = Lists.newArrayList();
    private AtomicInteger currentStepIndex = new AtomicInteger(0);
    private List<ConfigurationItem> discovered = Lists.newArrayList();
    private List<ConfigurationItem> inspected = Lists.newArrayList();

    public InspectionContext(ExecutionContext context) {
        this.context = (ExecutionContext)Preconditions.checkNotNull((Object)context);
    }

    public InspectionContext(Map<String, Object> attributes) {
        this.attributes = (Map)Preconditions.checkNotNull(attributes);
    }

    public void startStepExecution(Step<?> step) {
        if (this.attributes != null) {
            this.stepLogger = LoggerFactory.getLogger(step.getClass());
        }
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public void discovered(ConfigurationItem item) {
        this.discovered.add(item);
    }

    void inspected(ConfigurationItem item) {
        this.discovered.remove(item);
        this.inspected.add(item);
    }

    public void logOutput(String output) {
        if (this.context != null) {
            this.context.logOutput(output);
        }
        if (this.stepLogger != null) {
            this.stepLogger.info(output);
        }
    }

    public void logError(String error) {
        if (this.context != null) {
            this.context.logError(error);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(error);
        }
    }

    public void logError(String error, Throwable t) {
        if (this.context != null) {
            this.context.logError(error, t);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(error, t);
        }
    }

    public Object getAttribute(String name) {
        if (this.context != null) {
            return this.context.getAttribute(name);
        }
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        throw new IllegalStateException(this + " has no context and no attributes");
    }

    public void setAttribute(String name, Object object) {
        if (this.context != null) {
            this.context.setAttribute(name, object);
        }
        if (this.attributes != null) {
            this.attributes.put(name, object);
        }
    }

    List<ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public List<ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public Step getNextStep() {
        if (this.currentStepIndex.get() < this.steps.size()) {
            return this.steps.get(this.currentStepIndex.getAndIncrement());
        }
        return null;
    }
}

