/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.overthere.OverthereFile;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CiTemplateModel
extends BeanModel {
    private static final String FILE_ATTRIBUTE = "file";
    private Descriptor descriptor;
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        super((Object)ci, (BeansWrapper)wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        this.descriptor = DescriptorRegistry.getDescriptor((Type)ci.getType());
    }

    public TemplateModel get(String key) throws TemplateModelException {
        PropertyDescriptor pd;
        if (key.equals(FILE_ATTRIBUTE)) {
            if (this.ci instanceof DeployableArtifact) {
                return this.handleDeployableArtifactFile();
            }
            if (this.ci instanceof DerivedArtifact) {
                return this.handleDerivedArtifactFile();
            }
        }
        if ((pd = this.descriptor.getPropertyDescriptor(key)) == null) {
            return super.get(key);
        }
        return this.wrapper.wrap(this.extractValueFromCi(pd));
    }

    private Object extractValueFromCi(PropertyDescriptor pd) {
        HashMap ctx = Maps.newHashMap();
        if (this.ci instanceof AbstractDeployed) {
            ctx.put("deployed", this.ci);
        } else if (this.ci instanceof Container || this.ci instanceof NestedContainer) {
            ctx.put("container", this.ci);
        }
        switch (pd.getKind()) {
            case STRING: {
                return ConfigurationHolder.resolveExpression((String)pd.get(this.ci), (Object)ctx);
            }
            case SET_OF_STRING: {
                return ConfigurationHolder.resolveExpression((Set)pd.get(this.ci), (Object)ctx);
            }
            case LIST_OF_STRING: {
                return ConfigurationHolder.resolveExpression((List)pd.get(this.ci), (Object)ctx);
            }
            case MAP_STRING_STRING: {
                return ConfigurationHolder.resolveExpression((Map)pd.get(this.ci), ctx);
            }
        }
        return pd.get(this.ci);
    }

    private TemplateModel handleDeployableArtifactFile() throws TemplateModelException {
        return this.uploadFile(((DeployableArtifact)this.ci).getFile());
    }

    private TemplateModel handleDerivedArtifactFile() throws TemplateModelException {
        return this.uploadFile(((DerivedArtifact)this.ci).getFile());
    }

    private TemplateModel uploadFile(OverthereFile file) throws TemplateModelException {
        Object o = file;
        if (this.wrapper.getUploader() != null) {
            o = this.wrapper.getUploader().upload(file);
        }
        return this.wrapper.wrap(o);
    }

    public boolean isEmpty() {
        return false;
    }
}

