/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import org.slf4j.MDC;

public class TemplateArtifactCopyStep
extends ArtifactCopyStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    private Map<String, Object> vars;
    private String templatePath;

    public TemplateArtifactCopyStep(int order, HostContainer container, Map<String, Object> vars, String templatePath, String targetPath) {
        super(order, null, container, targetPath);
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        this.templatePath = templatePath;
        Preconditions.checkNotNull((Object)templatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            Step.Result result = super.doExecute();
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile localTemp = this.getLocalConnection().getTempFile("generic_plugin", ".tmp");
        this.evaluateTemplate(localTemp, this.templatePath, this.vars);
        return localTemp;
    }
}

