/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.sasn1.Asn1Generator;

public class BerGenerator
extends Asn1Generator {
    private boolean _tagged = false;
    private boolean _isExplicit;
    private int _tagNo;

    protected BerGenerator(OutputStream outputStream) {
        super(outputStream);
    }

    public BerGenerator(OutputStream outputStream, int n, boolean bl) {
        super(outputStream);
        this._tagged = true;
        this._isExplicit = bl;
        this._tagNo = n;
    }

    public OutputStream getRawOutputStream() {
        return this._out;
    }

    private void writeHdr(int n) throws IOException {
        this._out.write(n);
        this._out.write(128);
    }

    protected void writeBerHeader(int n) throws IOException {
        int n2 = this._tagNo | 0x80;
        if (this._tagged) {
            if (this._isExplicit) {
                this.writeHdr(n2 | 0x20);
                this.writeHdr(n);
            } else if ((n & 0x20) != 0) {
                this.writeHdr(n2 | 0x20);
            } else {
                this.writeHdr(n2);
            }
        } else {
            this.writeHdr(n);
        }
    }

    protected void writeBerBody(InputStream inputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) >= 0) {
            this._out.write(n);
        }
    }

    protected void writeBerEnd() throws IOException {
        this._out.write(0);
        this._out.write(0);
        if (this._tagged && this._isExplicit) {
            this._out.write(0);
            this._out.write(0);
        }
    }
}

