/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.TokenGenerator;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.connector.JdkHttpConnector;
import com.xebialabs.overthere.cifs.winrm.connector.LaxJdkHttpConnector;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import com.xebialabs.overthere.cifs.winrm.tokengenerator.BasicTokenGenerator;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.net.MalformedURLException;
import java.net.URL;

public class CifsWinRmConnection
extends CifsConnection {
    private final WinRmClient winRmClient;

    public CifsWinRmConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper, false);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        TokenGenerator tokenGenerator = this.getTokenGenerator(connectionOptions);
        URL uRL = this.getTargetURL(connectionOptions);
        HttpConnector httpConnector = CifsWinRmConnection.newHttpConnector(this.cifsConnectionType, uRL, tokenGenerator);
        this.winRmClient = new WinRmClient(httpConnector, uRL);
        this.winRmClient.setTimeout(connectionOptions.get("winrmTimeout", "PT60.000S"));
        this.winRmClient.setEnvelopSize(connectionOptions.get("winrmEnvelopSize", 153600));
        this.winRmClient.setLocale(connectionOptions.get("winrmLocale", "en-US"));
    }

    private TokenGenerator getTokenGenerator(ConnectionOptions connectionOptions) {
        String string = (String)connectionOptions.get("username");
        String string2 = (String)connectionOptions.get("password");
        return new BasicTokenGenerator(string, string2);
    }

    private URL getTargetURL(ConnectionOptions connectionOptions) {
        String string = this.cifsConnectionType == CifsConnectionType.WINRM_HTTP ? "http" : "https";
        String string2 = connectionOptions.get("winrmContext", "/wsman");
        try {
            return new URL(string, this.address, this.port, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new WinRMRuntimeIOException("Cannot build a new URL for " + this, malformedURLException);
        }
    }

    public static HttpConnector newHttpConnector(CifsConnectionType cifsConnectionType, URL uRL, TokenGenerator tokenGenerator) {
        switch (cifsConnectionType) {
            case WINRM_HTTP: {
                return new JdkHttpConnector(uRL, tokenGenerator);
            }
            case WINRM_HTTPS: {
                return new LaxJdkHttpConnector(uRL, tokenGenerator);
            }
        }
        throw new IllegalArgumentException("Invalid CIFS connection type " + (Object)((Object)cifsConnectionType));
    }

    @Override
    public int execute(OverthereProcessOutputHandler overthereProcessOutputHandler, CmdLine cmdLine) {
        String string = cmdLine.toCommandLine(this.getHostOperatingSystem(), false);
        if (this.workingDirectory != null) {
            string = "CD " + this.workingDirectory.getPath() + " & " + string;
        }
        this.winRmClient.runCmd(string, overthereProcessOutputHandler);
        return this.winRmClient.getExitCode();
    }
}

