/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentOperationCalculator;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.deployment.InitialDeploymentTask;
import com.xebialabs.deployit.task.deployment.UndeploymentTask;
import com.xebialabs.deployit.task.deployment.UpgradeDeploymentTask;
import com.xebialabs.deployit.task.step.RepositoryUpdateStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeploymentService {
    private RepositoryService repositoryService;
    private Planner planner;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);

    @Autowired
    public DeploymentService(RepositoryService repositoryService, Planner planner) {
        this.repositoryService = repositoryService;
        this.planner = planner;
    }

    public Task prepareInitialDeployment(DeployedApplication deployedApp, Collection<Deployed> deployedPojos, WorkDir workDir) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().initial(deployedApp);
        DeploymentOperationCalculator.calculate(builder, Sets.newHashSet(), Sets.newHashSet(deployedPojos));
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        List<DeploymentStep> steps = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new InitialDeploymentTask(specification, steps, this.repositoryService, workDir);
    }

    public Task prepareUpgradeDeployment(DeployedApplication newDeployment, DeployedApplication existingDeployment, Collection<Deployed> deployeds, WorkDir oldWorkDir, WorkDir newWorkDir) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().upgrade(newDeployment);
        HashSet incomingDeployedPojos = Sets.newHashSet(deployeds);
        logger.trace("Incoming Deployeds {}", (Object)incomingDeployedPojos);
        logger.trace("Existing Deployeds {}", (Object)existingDeployment.getDeployeds());
        DeploymentOperationCalculator.calculate(builder, existingDeployment.getDeployeds(), incomingDeployedPojos);
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        List<DeploymentStep> steps = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new UpgradeDeploymentTask(specification, existingDeployment, steps, this.repositoryService, oldWorkDir, newWorkDir);
    }

    public Task prepareUndeployment(DeployedApplication deployedApplication, WorkDir workDir) {
        DeltaSpecificationBuilder builder = DeltaSpecificationBuilder.newSpecification().undeploy(deployedApplication);
        DeploymentOperationCalculator.calculate(builder, deployedApplication.getDeployeds(), Sets.newHashSet());
        DeltaSpecification specification = builder.build();
        Plan plan = this.planner.plan(specification);
        List<DeploymentStep> steps = this.getStepsFromPlanOrDefaultUpdateStep(plan);
        return new UndeploymentTask(specification, deployedApplication, steps, this.repositoryService, workDir);
    }

    private List<DeploymentStep> getStepsFromPlanOrDefaultUpdateStep(Plan plan) {
        List steps = plan.getSteps();
        if (steps.isEmpty()) {
            steps = Lists.newArrayList((Object[])new DeploymentStep[]{new RepositoryUpdateStep()});
        }
        return steps;
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class DeploymentException
    extends DeployitException {
        public DeploymentException(String message) {
            super(message);
        }
    }
}

