/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.task.ExecutionContextAttributes;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TaskStep
extends TaskStepInfo {
    private static final String MDC_KEY_STEP_DESCRIPTION = "stepDescription";
    public static final String ERROR_PREFIX = "[ERROR]: ";
    private final Step step;
    private static final Logger logger = LoggerFactory.getLogger(TaskStep.class);

    public TaskStep(Step step) {
        this(step, TaskStepInfo.StepState.PENDING);
    }

    TaskStep(Step step, TaskStepInfo.StepState state) {
        super(step.getDescription());
        this.step = step;
        this.setState(state);
    }

    TaskStep(String description, TaskStepInfo.StepState state) {
        super(description);
        this.setState(state);
        this.step = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContextAttributes taskContext) {
        MDC.put((String)MDC_KEY_STEP_DESCRIPTION, (String)this.step.getDescription());
        try {
            if (this.getState() != TaskStepInfo.StepState.PENDING && this.getState() != TaskStepInfo.StepState.FAILED) {
                logger.debug("Will not execute: {} with description: {} because it has state: {}", new Object[]{this.step, this.step.getDescription(), this.getState()});
                return;
            }
            this.setStartDate();
            this.setState(TaskStepInfo.StepState.EXECUTING);
            this.clearLog();
            logger.info("Started {}", (Object)this);
            TaskStepDeploymentExecutionContext context = new TaskStepDeploymentExecutionContext(taskContext);
            try {
                Step.Result result = this.step.execute((ExecutionContext)context);
                this.setState(result == Step.Result.Success ? TaskStepInfo.StepState.DONE : TaskStepInfo.StepState.FAILED);
            }
            catch (Exception exc) {
                context.logError("Step failed", exc);
                this.setState(TaskStepInfo.StepState.FAILED);
            }
            catch (Throwable t) {
                context.logError("Step failed badly, aborting!", t);
                Thread.currentThread().interrupt();
                this.setState(TaskStepInfo.StepState.FAILED);
            }
            finally {
                logger.info("{}", (Object)this.getState());
            }
            this.setCompletionDate();
        }
        finally {
            MDC.remove((String)MDC_KEY_STEP_DESCRIPTION);
        }
    }

    protected void transitionExecutingStateToFailedState() {
        if (this.getState() == TaskStepInfo.StepState.EXECUTING) {
            this.setState(TaskStepInfo.StepState.FAILED);
        }
    }

    public Step getImplementation() {
        return this.step;
    }

    @Override
    protected void setState(TaskStepInfo.StepState state) {
        super.setState(state);
        if (state == TaskStepInfo.StepState.FAILED) {
            this.setFailureCount(this.getFailureCount() + 1);
        }
        this.setLastModificationDate();
    }

    protected void setStartDate() {
        super.setStartDate(Calendar.getInstance());
        this.setLastModificationDate();
    }

    protected void setCompletionDate() {
        super.setCompletionDate(Calendar.getInstance());
        this.setLastModificationDate();
    }

    public void clearLog() {
        this.setLog("");
    }

    protected void setLastModificationDate() {
        super.setLastModificationDate(Calendar.getInstance());
    }

    public void skip() {
        this.setState(TaskStepInfo.StepState.SKIPPED);
    }

    public void unskip() {
        this.setState(TaskStepInfo.StepState.PENDING);
    }

    public boolean isSkipped() {
        return this.getState() == TaskStepInfo.StepState.SKIPPED;
    }

    public boolean canSkip() {
        return this.getState() == TaskStepInfo.StepState.PENDING || this.getState() == TaskStepInfo.StepState.FAILED;
    }

    public String toString() {
        return "[" + this.step.getDescription() + "]";
    }

    public boolean isFailed() {
        return this.getState() == TaskStepInfo.StepState.FAILED;
    }

    class TaskStepDeploymentExecutionContext
    implements DeploymentExecutionContext {
        private ExecutionContextAttributes taskContext;
        private Logger stepLogger;

        TaskStepDeploymentExecutionContext(ExecutionContextAttributes taskContext) {
            this.taskContext = taskContext;
            this.stepLogger = LoggerFactory.getLogger(TaskStep.this.step.getClass());
        }

        public synchronized void logOutput(String output) {
            this.stepLogger.info(output);
            TaskStep.this.setLog(TaskStep.this.getLog() + output + "\n");
            TaskStep.this.setLastModificationDate();
        }

        public synchronized void logError(String error) {
            this.stepLogger.error(error);
            this.appendErrorToLog(error);
            TaskStep.this.setLastModificationDate();
        }

        public synchronized void logError(String error, Throwable t) {
            this.stepLogger.error(error, t);
            this.appendErrorToLog(error);
            StringWriter stringWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(stringWriter));
            for (String stackTraceLine : stringWriter.toString().split("\n")) {
                this.appendErrorToLog(stackTraceLine);
            }
            TaskStep.this.setLastModificationDate();
        }

        private void appendErrorToLog(String error) {
            TaskStep.this.setLog(TaskStep.this.getLog() + TaskStep.ERROR_PREFIX + error + "\n");
        }

        public Object getAttribute(String name) {
            Object object = this.taskContext.getAttribute(name);
            this.stepLogger.debug("Getting value of attribute {}: {}", (Object)name, object);
            return object;
        }

        public void setAttribute(String name, Object object) {
            this.stepLogger.debug("Setting value of attribute {}: {}", (Object)name, object);
            this.taskContext.setAttribute(name, object);
        }
    }
}

