/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.jcrarchive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import com.xebialabs.deployit.task.jcrarchive.JcrArchivedTaskSearchQueryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTaskArchive
implements TaskArchive {
    static final String STATE = "state";
    static final String START_DATE = "startDate";
    static final String COMPLETION_DATE = "completionDate";
    static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    static final String NR_OF_STEPS = "nrOfSteps";
    static final String CURRENT_STEP_NR = "currentStepNr";
    static final String OWNING_USER = "ownerUser";
    static final String FAILURE_COUNT = "failureCount";
    static final String LOG = "log";
    static final String DESCRIPTION = "description";
    static final String APPLICATION = "application";
    static final String VERSION = "version";
    static final String ENVIRONMENT = "environment";
    static final String DEPLOYMENT_TYPE = "deploymentType";
    public static final String ENVIRONMENTS_ROOT = "Environments/";
    private final JcrTemplate jcrTemplate;
    private static final Pattern qualifiedTaskIdPattern = Pattern.compile("^(.*)/(.*)/(.*)/(.*)$");

    @Autowired
    public JcrTaskArchive(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public void archiveTask(DeploymentTask task) {
        this.checkAllMandatoryAttributesArePresentInDeploymentTask(task);
        this.saveDeploymentTask(task);
    }

    private void checkAllMandatoryAttributesArePresentInDeploymentTask(DeploymentTask task) {
        Preconditions.checkState((!Strings.nullToEmpty((String)task.getApplicationName()).isEmpty() ? 1 : 0) != 0, (Object)"applicationName in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)task.getApplicationVersion()).isEmpty() ? 1 : 0) != 0, (Object)"applicationVersion in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)task.getEnvironment()).isEmpty() ? 1 : 0) != 0, (Object)"environment in deployment task must be set");
    }

    private void saveDeploymentTask(final DeploymentTask task) {
        this.jcrTemplate.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws IOException, RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.this.createJcrTaskNodeAndAssociatedParentNodes(task, JcrTaskArchive.this.getTasksRootNode(session));
                JcrTaskArchive.this.mapDeploymentTaskToJcrNode(task, jcrTaskNode);
                session.save();
                return null;
            }
        });
    }

    private Node createJcrTaskNodeAndAssociatedParentNodes(DeploymentTask task, Node tasksRootNode) throws RepositoryException {
        Node envNode = this.createNodeIfDoesNotExist(tasksRootNode, JcrTaskArchive.encodeEnvironmentId(task.getEnvironment()));
        Node appNode = this.createNodeIfDoesNotExist(envNode, task.getApplicationName());
        Node verNode = this.createNodeIfDoesNotExist(appNode, task.getApplicationVersion());
        Node node = verNode.addNode(task.getId());
        node.addMixin("deployit:task");
        return node;
    }

    static String encodeEnvironmentId(String id) {
        if (id.startsWith(ENVIRONMENTS_ROOT)) {
            id = id.substring(ENVIRONMENTS_ROOT.length());
        }
        return id.replace("/", "$#");
    }

    static String decodeEnvironmentId(String id) {
        if (!(id = id.replace("$#", "/")).startsWith(ENVIRONMENTS_ROOT)) {
            return ENVIRONMENTS_ROOT + id;
        }
        return id;
    }

    private Node createNodeIfDoesNotExist(Node parentNode, String nodeId) throws RepositoryException {
        if (parentNode.hasNode(nodeId)) {
            return parentNode.getNode(nodeId);
        }
        return parentNode.addNode(nodeId);
    }

    private void mapDeploymentTaskToJcrNode(DeploymentTask task, Node taskNode) throws IOException, RepositoryException {
        taskNode.setProperty("$id", task.getId());
        taskNode.setProperty(STATE, task.getState().name());
        taskNode.setProperty(START_DATE, task.getStartDate());
        taskNode.setProperty(COMPLETION_DATE, task.getCompletionDate());
        taskNode.setProperty(CURRENT_STEP_NR, (long)task.getCurrentStepNr());
        taskNode.setProperty(NR_OF_STEPS, (long)task.getNrOfSteps());
        taskNode.setProperty(OWNING_USER, task.getOwner());
        taskNode.setProperty(APPLICATION, task.getApplicationName());
        taskNode.setProperty(VERSION, task.getApplicationVersion());
        taskNode.setProperty(ENVIRONMENT, task.getEnvironment());
        taskNode.setProperty(FAILURE_COUNT, (long)task.getFailureCount());
        taskNode.setProperty(DEPLOYMENT_TYPE, task.getDeploymentType().name());
        for (int nr = 1; nr <= task.getNrOfSteps(); ++nr) {
            TaskStep step = task.getStep(nr);
            Node stepNode = taskNode.addNode("step" + nr);
            stepNode.setProperty(DESCRIPTION, step.getDescription());
            stepNode.setProperty(LAST_MODIFICATION_DATE, step.getLastModificationDate());
            stepNode.setProperty(STATE, step.getState().name());
            stepNode.setProperty(START_DATE, step.getStartDate());
            stepNode.setProperty(COMPLETION_DATE, step.getCompletionDate());
            stepNode.setProperty(FAILURE_COUNT, (long)step.getFailureCount());
            stepNode.setProperty(LOG, step.getLog());
        }
    }

    @Override
    public DeploymentTaskInfo getTask(String taskId) {
        Matcher matcher = qualifiedTaskIdPattern.matcher(taskId);
        if (matcher.matches()) {
            String internalId = JcrTaskArchive.encodeEnvironmentId(matcher.group(1)) + "/" + matcher.group(2) + "/" + matcher.group(3) + "/" + matcher.group(4);
            return this.getTaskUsingFullyQualifiedPath(internalId);
        }
        return this.getTaskUsingUuid(taskId);
    }

    private DeploymentTaskInfo getTaskUsingFullyQualifiedPath(final String fullyQualifiedPath) {
        return this.jcrTemplate.execute(new JcrCallback<DeploymentTaskInfo>(){

            @Override
            public DeploymentTaskInfo doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node tasksNode = JcrTaskArchive.this.getTasksRootNode(session);
                    Node taskNode = tasksNode.getNode(fullyQualifiedPath);
                    DeploymentTaskInfo task = JcrTaskArchive.this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(taskNode);
                    if (task == null) {
                        throw new NotFoundException("Cannot load task " + fullyQualifiedPath + " because that object with that id is not a task", new Object[0]);
                    }
                    task.setSteps(JcrTaskArchive.this.loadTaskStepInfosForJcrTaskNode(taskNode));
                    return task;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Cannot load task " + fullyQualifiedPath + ": " + exc.toString(), new Object[]{exc});
                }
            }
        });
    }

    private DeploymentTaskInfo getTaskUsingUuid(String taskUuid) {
        ArchivedTaskSearchParameters taskSearch = new ArchivedTaskSearchParameters();
        taskSearch.withUniqueId(taskUuid);
        Collection<DeploymentTaskInfo> deploymentTaskInfos = this.searchTasks(taskSearch);
        if (deploymentTaskInfos.size() == 1) {
            return deploymentTaskInfos.iterator().next();
        }
        if (deploymentTaskInfos.isEmpty()) {
            throw new NotFoundException("Cannot load task " + taskUuid, new Object[0]);
        }
        throw new NotFoundException("Cannot load task " + taskUuid + " because there are multiple tasks with same id. " + deploymentTaskInfos, new Object[0]);
    }

    private DeploymentTaskInfo mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(Node taskNode) throws RepositoryException {
        if (!taskNode.isNodeType("deployit:task")) {
            return null;
        }
        DeploymentTaskInfo task = new DeploymentTaskInfo();
        task.setId(this.getPropertyFromJcrNode(taskNode, "$id"));
        task.setEnvironment(JcrTaskArchive.decodeEnvironmentId(this.getPropertyFromJcrNode(taskNode, ENVIRONMENT)));
        task.setApplicationName(this.getPropertyFromJcrNode(taskNode, APPLICATION));
        task.setApplicationVersion(this.getPropertyFromJcrNode(taskNode, VERSION));
        task.setState(Task.State.valueOf(this.getPropertyFromJcrNode(taskNode, STATE)));
        task.setDeploymentType(DeploymentTask.DeploymentType.valueOf(this.getPropertyFromJcrNode(taskNode, DEPLOYMENT_TYPE)));
        task.setStartDate(this.getOptionalDatePropertyFromJcrNode(taskNode, START_DATE));
        task.setCompletionDate(this.getOptionalDatePropertyFromJcrNode(taskNode, COMPLETION_DATE));
        task.setOwner(this.getOptionalPropertyFromJcrNode(taskNode, OWNING_USER));
        task.setCurrentStepNr(this.getIntegerPropertyFromJcrNode(taskNode, CURRENT_STEP_NR));
        task.setFailureCount(this.getIntegerPropertyFromJcrNode(taskNode, FAILURE_COUNT));
        return task;
    }

    private String getPropertyFromJcrNode(Node node, String propName) throws RepositoryException {
        return node.getProperty(propName).getString();
    }

    private int getIntegerPropertyFromJcrNode(Node node, String propName) throws RepositoryException {
        return (int)node.getProperty(propName).getLong();
    }

    private Calendar getOptionalDatePropertyFromJcrNode(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getDate();
        }
        return null;
    }

    private String getOptionalPropertyFromJcrNode(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getString();
        }
        return null;
    }

    private List<TaskStepInfo> loadTaskStepInfosForJcrTaskNode(Node taskNode) throws RepositoryException {
        int nrOfSteps = this.getIntegerPropertyFromJcrNode(taskNode, NR_OF_STEPS);
        ArrayList steps = Lists.newArrayList();
        for (int nr = 1; nr <= nrOfSteps; ++nr) {
            Node stepNode = taskNode.getNode("step" + nr);
            steps.add(this.mapJcrStepNodeToTaskStepInfo(stepNode));
        }
        return steps;
    }

    private TaskStepInfo mapJcrStepNodeToTaskStepInfo(Node stepNode) throws RepositoryException {
        String description = this.getPropertyFromJcrNode(stepNode, DESCRIPTION);
        TaskStepInfo.StepState stepState = TaskStepInfo.StepState.valueOf(this.getPropertyFromJcrNode(stepNode, STATE));
        Calendar startDate = this.getOptionalDatePropertyFromJcrNode(stepNode, START_DATE);
        Calendar endDate = this.getOptionalDatePropertyFromJcrNode(stepNode, COMPLETION_DATE);
        Calendar lastModificationDate = this.getOptionalDatePropertyFromJcrNode(stepNode, LAST_MODIFICATION_DATE);
        String log = this.getPropertyFromJcrNode(stepNode, LOG);
        int failureCount = this.getIntegerPropertyFromJcrNode(stepNode, FAILURE_COUNT);
        return new TaskStepInfo(description, stepState, startDate, endDate, lastModificationDate, log, failureCount);
    }

    private Node getTasksRootNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("tasks");
    }

    @Override
    public Collection<DeploymentTaskInfo> searchTasks(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, true);
    }

    @Override
    public Collection<DeploymentTaskInfo> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, false);
    }

    private List<DeploymentTaskInfo> searchTasks(final ArchivedTaskSearchParameters params, final boolean loadSteps) {
        return this.jcrTemplate.execute(new JcrCallback<List<DeploymentTaskInfo>>(){

            @Override
            public List<DeploymentTaskInfo> doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, params);
                final ArrayList tasks = Lists.newArrayList();
                JcrTaskArchive.this.mapQueryResultToDeploymentTasks(queryResult, loadSteps, new TaskCallback(){

                    @Override
                    public void doWithTask(DeploymentTaskInfo t) {
                        tasks.add(t);
                    }
                });
                return tasks;
            }
        });
    }

    @Override
    public void searchTasks(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, true);
    }

    @Override
    public void searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, false);
    }

    private Object searchTasks(final ArchivedTaskSearchParameters params, final TaskCallback callback, final boolean loadSteps) {
        return this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, params);
                JcrTaskArchive.this.mapQueryResultToDeploymentTasks(queryResult, loadSteps, callback);
                return null;
            }
        });
    }

    private QueryResult executeJcrQuery(Session session, ArchivedTaskSearchParameters params) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        JcrArchivedTaskSearchQueryBuilder queryBuilder = new JcrArchivedTaskSearchQueryBuilder(qm, session.getValueFactory(), params);
        QueryObjectModel query = queryBuilder.buildQuery();
        return query.execute();
    }

    private void mapQueryResultToDeploymentTasks(QueryResult result, boolean loadSteps, TaskCallback callback) throws RepositoryException {
        RowIterator iterator = result.getRows();
        while (iterator.hasNext()) {
            try {
                Node taskNode = iterator.nextRow().getNode("task");
                DeploymentTaskInfo task = this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(taskNode);
                if (loadSteps) {
                    task.setSteps(this.loadTaskStepInfosForJcrTaskNode(taskNode));
                }
                callback.doWithTask(task);
            }
            catch (RepositoryException rre) {}
        }
    }

    @Override
    public List<String> getAllTaskIds() {
        return this.jcrTemplate.execute(new JcrCallback<List<String>>(){

            @Override
            public List<String> doInJcr(Session session) throws IOException, RepositoryException {
                QueryResult queryResult = JcrTaskArchive.this.executeJcrQuery(session, new ArchivedTaskSearchParameters());
                return JcrTaskArchive.this.mapQueryResultToTasksIds(queryResult);
            }
        });
    }

    @Override
    public List<String> getAllEnvironments() {
        return this.jcrTemplate.execute(new JcrCallback<List<String>>(){

            @Override
            public List<String> doInJcr(Session session) throws IOException, RepositoryException {
                ArrayList envs = Lists.newArrayList();
                NodeIterator nodes = session.getNode("/tasks").getNodes();
                while (nodes.hasNext()) {
                    envs.add(JcrTaskArchive.decodeEnvironmentId(nodes.nextNode().getName()));
                }
                return envs;
            }
        });
    }

    private List<String> mapQueryResultToTasksIds(QueryResult queryResult) throws RepositoryException {
        ArrayList taskIds = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                taskIds.add(this.getPropertyFromJcrNode(iterator.nextRow().getNode("task"), "$id"));
            }
            catch (RepositoryException rre) {}
        }
        return taskIds;
    }

    @Override
    public Collection<Map<String, Object>> searchTasksWithoutLoadingSteps(final ArchivedTaskSearchParameters params, final GroupBy groupBy) {
        return (Collection)this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Collection<Map<String, Object>> doInJcr(Session session) throws IOException, RepositoryException {
                RowIterator iterator = JcrTaskArchive.this.executeJcrQuery(session, params).getRows();
                while (iterator.hasNext()) {
                    Node taskNode = iterator.nextRow().getNode("task");
                    groupBy.process(JcrTaskArchive.this.mapJcrTaskNodeToDeploymentTaskWithoutLoadingSteps(taskNode));
                }
                return groupBy.getResult();
            }
        });
    }

    public static interface TaskCallback {
        public void doWithTask(DeploymentTaskInfo var1);
    }
}

