/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultModel;
import de.schlichtherle.truezip.fs.FsFederatingController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.util.Link;
import de.schlichtherle.truezip.util.Links;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsDefaultManager
extends FsManager {
    private final Map<FsMountPoint, Link<FsFederatingController>> schedulers = new WeakHashMap<FsMountPoint, Link<FsFederatingController>>();
    private final Link.Type optionalScheduleType;

    public FsDefaultManager() {
        this(Link.Type.WEAK);
    }

    FsDefaultManager(Link.Type optionalScheduleType) {
        assert (null != optionalScheduleType);
        this.optionalScheduleType = optionalScheduleType;
    }

    @Override
    public synchronized FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver) {
        return this.getController(mountPoint, null, driver);
    }

    private FsController<?> getController(FsMountPoint mountPoint, @CheckForNull FsController<?> parent, FsCompositeDriver driver) {
        if (null == mountPoint.getParent()) {
            if (null != parent) {
                throw new IllegalArgumentException("Parent/member mismatch!");
            }
            FsDefaultModel model = new FsDefaultModel(mountPoint, null);
            return driver.newController(model, null);
        }
        FsFederatingController controller = Links.getTarget(this.schedulers.get(mountPoint));
        if (null == controller) {
            if (null == parent) {
                parent = this.getController(mountPoint.getParent(), null, driver);
            }
            ScheduledModel model = new ScheduledModel(mountPoint, (FsModel)parent.getModel());
            controller = new FsFederatingController(driver.newController(model, parent));
            model.setController(controller);
        }
        return controller;
    }

    @Override
    public synchronized int getSize() {
        return this.schedulers.size();
    }

    @Override
    public synchronized Iterator<FsController<?>> iterator() {
        return this.getControllers().iterator();
    }

    private Set<FsController<?>> getControllers() {
        TreeSet snapshot = new TreeSet(FsControllerComparator.REVERSE);
        for (Link<FsFederatingController> link : this.schedulers.values()) {
            FsController controller = Links.getTarget(link);
            if (null == controller) continue;
            snapshot.add(controller);
        }
        return snapshot;
    }

    private static final class FsControllerComparator
    implements Comparator<FsController<?>> {
        static final FsControllerComparator REVERSE = new FsControllerComparator();

        private FsControllerComparator() {
        }

        @Override
        public int compare(FsController<?> l, FsController<?> r) {
            return ((FsModel)r.getModel()).getMountPoint().toHierarchicalUri().compareTo(((FsModel)l.getModel()).getMountPoint().toHierarchicalUri());
        }
    }

    private final class ScheduledModel
    extends FsDefaultModel {
        FsFederatingController controller;
        volatile boolean touched;

        ScheduledModel(FsMountPoint mountPoint, FsModel parent) {
            super(mountPoint, parent);
        }

        void setController(FsFederatingController controller) {
            assert (null != controller);
            assert (!this.touched);
            this.controller = controller;
            this.schedule(false);
        }

        @Override
        public boolean isTouched() {
            return this.touched;
        }

        @Override
        public void setTouched(boolean touched) {
            if (touched == this.touched) {
                return;
            }
            this.touched = touched;
            this.schedule(touched);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(boolean mandatory) {
            FsDefaultManager fsDefaultManager = FsDefaultManager.this;
            synchronized (fsDefaultManager) {
                FsDefaultManager.this.schedulers.put(this.getMountPoint(), (mandatory ? Link.Type.STRONG : FsDefaultManager.this.optionalScheduleType).newLink(this.controller));
            }
        }
    }
}

