/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.scripts;

import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.utils.TFileUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class ScriptUtils {
    public static final String MDC_KEY_SCRIPT_PATH = "scriptPath";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScript(String scriptPath) {
        String string;
        URL scriptUrl = Thread.currentThread().getContextClassLoader().getResource(scriptPath);
        if (scriptUrl == null) {
            throw new IllegalArgumentException("Cannot load script from " + scriptPath + ": script does not exist on classpath");
        }
        TFile scriptFile = null;
        try {
            scriptFile = new TFile(new URI(scriptUrl.toString()));
            string = ScriptUtils.loadScriptFromFile(scriptFile);
        }
        catch (URISyntaxException exc) {
            try {
                throw new RuntimeIOException("Cannot load script from " + scriptPath, (Throwable)exc);
                catch (IOException exc2) {
                    throw new RuntimeIOException("Cannot load script from " + scriptPath, (Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                TFileUtils.umountQuietly(scriptFile);
                throw throwable;
            }
        }
        TFileUtils.umountQuietly((TFile)scriptFile);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScriptDir(String scriptDirPath) {
        String string;
        if (scriptDirPath == null) {
            return "";
        }
        URL scriptDirUrl = Thread.currentThread().getContextClassLoader().getResource(scriptDirPath);
        if (scriptDirUrl == null) {
            throw new IllegalArgumentException("Cannot load scripts from " + scriptDirPath + ": script directory does not exist on classpath");
        }
        TFile scriptDir = null;
        try {
            scriptDir = new TFile(new URI(scriptDirUrl.toString()));
            TFile[] scriptDirFiles = scriptDir.listFiles();
            if (scriptDirFiles == null) {
                throw new IllegalArgumentException("Cannot load scripts from " + scriptDir + ": not a directory");
            }
            StringBuilder b = new StringBuilder();
            for (TFile scriptFile : scriptDirFiles) {
                b.append(ScriptUtils.loadScriptFromFile(scriptFile));
            }
            string = b.toString();
        }
        catch (URISyntaxException exc) {
            try {
                throw new RuntimeIOException("Cannot read scripts from " + scriptDirPath, (Throwable)exc);
                catch (IOException exc2) {
                    throw new RuntimeIOException("Cannot read scripts from " + scriptDirPath, (Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                TFileUtils.umountQuietly(scriptDir);
                throw throwable;
            }
        }
        TFileUtils.umountQuietly((TFile)scriptDir);
        return string;
    }

    public static String loadScriptFromFile(TFile scriptFile) throws FileNotFoundException {
        TFileReader scriptReader = new TFileReader(scriptFile);
        try {
            String string = "# " + scriptFile + "\n" + CharStreams.toString((Readable)scriptReader);
            return string;
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot load script from " + scriptFile, exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)scriptReader);
        }
    }

    public static void dumpScript(String scriptTemplateName, String evaluatedScriptContents, Logger logger) {
        if (logger.isTraceEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            logger.trace(":::: " + df.format(new Date()) + " :::: " + scriptTemplateName + " ::::");
            String[] lines = evaluatedScriptContents.split("\r?\n");
            for (int i = 0; i < lines.length; ++i) {
                logger.trace(i + 1 + " : " + lines[i]);
            }
        }
    }

    public static OverthereFile uploadScript(OverthereConnection connection, String scriptFileNameTemplate, String scriptContents) {
        OverthereFile uploadedFile = connection.getTempFile(OverthereUtils.getName((String)scriptFileNameTemplate));
        OverthereUtils.write((String)scriptContents, (String)"UTF-8", (OverthereFile)uploadedFile);
        return uploadedFile;
    }
}

