/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipKeyException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class WinZipAesEntryParameters {
    private final WinZipAesParameters param;
    private final ZipEntry entry;

    public WinZipAesEntryParameters(WinZipAesParameters param, ZipEntry entry) {
        assert (null != param);
        assert (null != entry);
        this.param = param;
        this.entry = entry;
    }

    ZipEntry getEntry() {
        return this.entry;
    }

    AesKeyStrength getKeyStrength() throws ZipKeyException {
        return this.param.getKeyStrength(this.entry.getName());
    }

    void setKeyStrength(AesKeyStrength keyStrength) throws ZipKeyException {
        this.param.setKeyStrength(this.entry.getName(), keyStrength);
    }

    byte[] getWritePassword() throws ZipKeyException {
        return this.param.getWritePassword(this.entry.getName());
    }

    byte[] getReadPassword(boolean invalid) throws ZipKeyException {
        return this.param.getReadPassword(this.entry.getName(), invalid);
    }
}

